/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.environment;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.OS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProcessingEnvironment {
    protected Map<String, String> procEnvironment;

    public synchronized Map<String, String> getProcEnvironment() throws IOException {
        if (this.procEnvironment == null) {
            this.procEnvironment = this.createProcEnvironment();
        }
        Map<String, String> copy2 = this.createEnvironmentMap();
        copy2.putAll(this.procEnvironment);
        return copy2;
    }

    protected Map<String, String> createProcEnvironment() throws IOException {
        if (this.procEnvironment == null) {
            Map<String, String> env = System.getenv();
            this.procEnvironment = this.createEnvironmentMap();
            this.procEnvironment.putAll(env);
        }
        return this.procEnvironment;
    }

    @Deprecated
    protected BufferedReader runProcEnvCommand() throws IOException {
        return null;
    }

    @Deprecated
    protected CommandLine getProcEnvCommand() {
        CommandLine commandLine = null;
        return commandLine;
    }

    private Map<String, String> createEnvironmentMap() {
        if (OS.isFamilyWindows()) {
            return new TreeMap<String, String>(new Comparator<String>(){

                @Override
                public int compare(String key0, String key1) {
                    return key0.compareToIgnoreCase(key1);
                }
            });
        }
        return new HashMap<String, String>();
    }
}

