<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

# Contributing to the Apache OzHera(incubating) Project

If you’re interested in identifying vulnerabilities or improving the Apache OzHera(incubating) project, we warmly welcome your involvement. Below is a guide to help you get started with contributing.

[[Chinese Contributing Document](./CONTRIBUTING_CN.md)]

## Topics

* [Reporting Security Issues](#reporting-security-issues)
* [Reporting General Issues](#reporting-general-issues)
* [Code and Documentation Contributions](#code-and-documentation-contributions)
* [Test Case Contributions](#test-case-contributions)
* [Participating in Any Way](#participating-in-any-way)
* [Code Style](#code-style)

## Reporting Security Issues

Security issues are handled with top priority. Please avoid public discussions of security vulnerabilities. If you discover a security issue in Apache OzHera(incubating), report it confidentially via email to [private@ozhera.apache.org](mailto:private@ozhera.apache.org).

## Reporting General Issues

User feedback is crucial to Apache OzHera(incubating)'s growth. After using Apache OzHera(incubating), feel free to share your suggestions or issues by creating a [New Issue](https://github.com/apache/ozhera/issues/new/choose). To improve communication efficiency, we encourage you to search for similar issues before opening a new one. Add your details to an existing issue when relevant rather than creating a duplicate.

Consider opening a new issue for:

* Bug Reports
* Feature Requests
* Performance Issues
* Functional Enhancements or Design Suggestions
* Testing Improvements
* Incomplete Documentation
* Other project-related inquiries

When reporting issues, please ensure to remove sensitive information such as passwords, keys, or private business data.

## Code and Documentation Contributions

We welcome all contributions that improve the Apache OzHera(incubating) project. On GitHub, all enhancements can be implemented through Pull Requests (PRs):

* If you spot typos or mistakes, please correct them!
* If you identify areas for improvement, submit an enhancement!
* If documentation is inaccurate or incomplete, update it!

> We look forward to your PR.

Please review Apache OzHera(incubating)'s guidelines on submitting PRs:

* [Workspace Preparation](#workspace-preparation)
* [Branch Definitions](#branch-definitions)
* [Commit Guidelines](#commit-guidelines)
* [PR Descriptions](#pr-descriptions)

### Workspace Preparation

Please fork the project and clone it to your local machine for development. Once you set up the remote repository, you can easily sync your code with upstream branches.

### Branch Definitions

The Apache OzHera(incubating) project uses the following branch types:

* **Development Branch**: For developing all new features and improvements
* **Release Branch**: Created when a version is officially released
* **Hotfix Branch**: Used to address urgent issues in the release version

### Commit Guidelines

We emphasize high-quality commits, which includes:

* Commit Messages: Use clear and specific commit messages, such as `docs: Update installation guide`
* Commit Content: Ensure each commit is complete and reviewable, and that it is linked to your GitHub ID

### PR Descriptions

PRs are the main way to make changes to Apache OzHera(incubating). We recommend using the [PR template](./.github/PULL_REQUEST_TEMPLATE.md) to describe your changes.

## Test Case Contributions

The Apache OzHera(incubating) project prioritizes functional test case contributions. We recommend using JUnit for unit tests and Mockito for integration tests.

## Participating in Any Way

Apache OzHera(incubating) collaborates on GitHub, and we encourage contributions in various ways:

* Answer others’ questions
* Help review others’ PR designs and code
* Discuss project improvement suggestions
* Write blogs or share experiences about Ozhera

## Code Style

The Apache OzHera(incubating) project adheres to the Alibaba Java Coding Guidelines.

### Guidelines

[Alibaba Java Coding Guidelines](https://alibaba.github.io/Alibaba-Java-Coding-Guidelines/)

### Optional IDE Plugin Installation

* **IDEA**: [p3c-idea-plugin installation](https://github.com/alibaba/p3c/blob/master/idea-plugin/README.md)
* **Eclipse**: [p3c-eclipse-plugin installation](https://github.com/alibaba/p3c/blob/master/eclipse-plugin/README.md)

In summary, **any help is a contribution**.