/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.prometheus.client.multi;

import com.xiaomi.youpin.prometheus.client.XmCounter;
import com.xiaomi.youpin.prometheus.client.XmGauge;
import com.xiaomi.youpin.prometheus.client.XmHistogram;
import com.xiaomi.youpin.prometheus.client.multi.MutiPrometheus;
import io.prometheus.client.CollectorRegistry;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutiMetrics {
    private static final Logger log = LoggerFactory.getLogger(MutiMetrics.class);
    public MutiPrometheus gMetricsMgr;
    public static final String GROUP = "group";
    public static final String SERVICE = "service";
    public static final String APPLICATION = "application";
    private CollectorRegistry registry = new CollectorRegistry(true);
    public static double[] DEFAULT_LATENCY_BUCKETS = new double[]{0.01, 0.05, 1.0, 5.0, 7.5, 10.0, 25.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 1500.0, 2000.0, 3000.0, 4000.0, 5000.0};

    public void init(String group, String service) {
        this.setGroup(group);
        this.setService(service);
    }

    public void setGroup(String group) {
        this.gMetricsMgr.getConstLabels().put(GROUP, group);
    }

    public void setService(String service) {
        this.gMetricsMgr.getConstLabels().put(SERVICE, service);
    }

    public MutiMetrics() {
        this.gMetricsMgr = new MutiPrometheus(this.registry);
        this.gMetricsMgr.setConstLabels(new HashMap<String, String>());
    }

    public CollectorRegistry getRegistry() {
        return this.registry;
    }

    public XmCounter newCounter(String metricName, String ... labelNames) {
        try {
            return this.gMetricsMgr.newCounter(metricName, labelNames);
        }
        catch (Throwable throwable) {
            log.warn(throwable.getMessage());
            return null;
        }
    }

    public XmGauge newGauge(String metricName, String ... labelNames) {
        return this.gMetricsMgr.newGauge(metricName, labelNames);
    }

    public XmHistogram newHistogram(String metricName, double[] buckets, String ... labelNames) {
        if (buckets != null && buckets.length > 0) {
            return this.gMetricsMgr.newHistogram(metricName, buckets, labelNames);
        }
        return this.gMetricsMgr.newHistogram(metricName, DEFAULT_LATENCY_BUCKETS, labelNames);
    }
}

