/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.model.project.group.HeraProjectGroupModel;
import org.apache.ozhera.app.dao.mapper.HeraProjectGroupMapper;
import org.apache.ozhera.app.model.HeraProjectGroup;
import org.apache.ozhera.app.model.HeraProjectGroupExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class HeraProjectGroupDao {
    private static final Logger log = LoggerFactory.getLogger(HeraProjectGroupDao.class);
    @Resource
    private HeraProjectGroupMapper projectGroupMapper;

    public Long count(HeraProjectGroupModel projectGroup) {
        HeraProjectGroupExample example = new HeraProjectGroupExample();
        HeraProjectGroupExample.Criteria ca = example.createCriteria();
        if (projectGroup.getStatus() != null) {
            ca.andStatusEqualTo(projectGroup.getStatus());
        } else {
            ca.andStatusEqualTo(0);
        }
        if (projectGroup.getType() != null) {
            ca.andTypeEqualTo(projectGroup.getType());
        }
        if (projectGroup.getParentGroupId() != null) {
            ca.andParentGroupIdEqualTo(projectGroup.getParentGroupId());
        }
        if (projectGroup.getRelationObjectId() != null) {
            ca.andRelationObjectIdEqualTo(projectGroup.getRelationObjectId());
        }
        if (StringUtils.isNotBlank((CharSequence)projectGroup.getName())) {
            ca.andNameLike("%" + projectGroup.getName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)projectGroup.getCnName())) {
            ca.andCnNameLike("%" + projectGroup.getCnName() + "%");
        }
        try {
            return this.projectGroupMapper.countByExample(example);
        }
        catch (Exception e) {
            log.error("HeraProjectGroupDao#count error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<HeraProjectGroupModel> search(HeraProjectGroupModel projectGroup, Integer page, Integer pageSize) {
        if (page == null || page == 0) {
            page = 1;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        HeraProjectGroupExample example = new HeraProjectGroupExample();
        HeraProjectGroupExample.Criteria ca = example.createCriteria();
        if (projectGroup.getStatus() != null) {
            ca.andStatusEqualTo(projectGroup.getStatus());
        } else {
            ca.andStatusEqualTo(0);
        }
        if (projectGroup.getType() != null) {
            ca.andTypeEqualTo(projectGroup.getType());
        }
        if (projectGroup.getParentGroupId() != null) {
            ca.andParentGroupIdEqualTo(projectGroup.getParentGroupId());
        }
        if (projectGroup.getRelationObjectId() != null) {
            ca.andRelationObjectIdEqualTo(projectGroup.getRelationObjectId());
        }
        if (StringUtils.isNotBlank((CharSequence)projectGroup.getName())) {
            ca.andNameLike("%" + projectGroup.getName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)projectGroup.getCnName())) {
            ca.andCnNameLike("%" + projectGroup.getCnName() + "%");
        }
        example.setOffset((page - 1) * pageSize);
        example.setLimit(pageSize);
        example.setOrderByClause("id desc");
        try {
            return this.projectGroupMapper.selectByExample(example);
        }
        catch (Exception e) {
            log.error("HeraProjectGroupDao#query error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<HeraProjectGroupModel> listByIds(List<Integer> ids, Integer type, String projectGroupName, Integer level) {
        if (CollectionUtils.isEmpty(ids)) {
            log.error("listByIds param is invalid! ids : {}", ids);
            return null;
        }
        HeraProjectGroupExample example = new HeraProjectGroupExample();
        HeraProjectGroupExample.Criteria ca = example.createCriteria();
        ca.andStatusEqualTo(0);
        ca.andIdIn((List)ids);
        if (StringUtils.isNotBlank((CharSequence)projectGroupName)) {
            ca.andNameLike("%" + projectGroupName + "%");
        }
        if (type != null) {
            ca.andTypeEqualTo(type);
        }
        if (level != null) {
            ca.andLevelLessThan(level);
        }
        try {
            return this.projectGroupMapper.selectByExample(example);
        }
        catch (Exception e) {
            log.error("HeraProjectGroupDao#listByIds error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Integer create(HeraProjectGroup heraProjectGroup) {
        heraProjectGroup.setStatus(0);
        heraProjectGroup.setCreateTime(new Date());
        heraProjectGroup.setUpdateTime(new Date());
        try {
            this.projectGroupMapper.insert(heraProjectGroup);
        }
        catch (Exception e) {
            log.error("create data fail! exception:{}", (Object)e.getMessage(), (Object)e);
        }
        return heraProjectGroup.getId();
    }

    public Integer update(HeraProjectGroup heraProjectGroup) {
        heraProjectGroup.setUpdateTime(new Date());
        try {
            this.projectGroupMapper.updateByPrimaryKeySelective(heraProjectGroup);
        }
        catch (Exception e) {
            log.error("create data fail! exception:{}", (Object)e.getMessage(), (Object)e);
        }
        return heraProjectGroup.getId();
    }

    public Integer delById(Integer id) {
        try {
            return this.projectGroupMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            log.error("delById data fail! exception:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

