/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.apache.ozhera.prometheus.agent.Commons;
import org.apache.ozhera.prometheus.agent.api.service.PrometheusAlertService;
import org.apache.ozhera.prometheus.agent.enums.ErrorCode;
import org.apache.ozhera.prometheus.agent.param.alert.RuleAlertParam;
import org.apache.ozhera.prometheus.agent.result.Result;
import org.apache.ozhera.prometheus.agent.service.prometheus.RuleAlertService;
import org.springframework.beans.factory.annotation.Autowired;

@Service(timeout=5000, group="${dubbo.group}")
public class PrometheusAlertServiceImpl
implements PrometheusAlertService {
    @Autowired
    RuleAlertService ruleAlertService;

    public Result createRuleAlert(RuleAlertParam param) {
        Result result = this.ruleAlertService.CreateRuleAlert(param);
        return result;
    }

    public Result UpdateRuleAlert(String id, RuleAlertParam param) {
        if (id == null || param == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Result result = this.ruleAlertService.UpdateRuleAlert(id, param);
        return result;
    }

    public Result DeleteRuleAlert(String id) {
        if (id == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Result result = this.ruleAlertService.DeleteRuleAlert(id);
        return result;
    }

    public Result GetRuleAlert(String id) {
        if (id == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Result result = this.ruleAlertService.GetRuleAlert(id);
        return result;
    }

    public Result GetRuleAlertList(Integer pageSize, Integer pageNo) {
        if (pageSize == null && pageNo == null) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        if (pageSize == null) {
            pageSize = Commons.COMMON_PAGE_SIZE;
        }
        if (pageNo == null) {
            pageNo = Commons.COMMON_PAGE_NO;
        }
        Result result = this.ruleAlertService.GetRuleAlertList(pageSize, pageNo);
        return result;
    }

    public Result EnabledRuleAlert(String id, String enabled) {
        if (id == null || StringUtils.isBlank((CharSequence)enabled) || !enabled.equals("0") && !enabled.equals("1")) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Result result = this.ruleAlertService.EnabledRuleAlert(id, enabled);
        return result;
    }
}

