/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.model.StorageInfo;
import org.apache.ozhera.log.stream.common.util.StreamUtils;
import org.apache.ozhera.log.stream.job.compensate.MqMessageDTO;
import org.apache.ozhera.log.stream.job.extension.MessageSender;
import org.apache.ozhera.log.stream.job.extension.MqMessageProduct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.mone.doris.DorisStreamLoad;

public class DorisMessageSender
implements MessageSender {
    private static final Logger log = LoggerFactory.getLogger(DorisMessageSender.class);
    private final String tableName;
    private final MqMessageProduct compensateMsgProduct;
    private final List<String> columnList;
    private DorisStreamLoad dorisStreamLoad;
    private static final Integer DEFAULT_PORT = 8030;
    private String dataBaseName;
    private ExecutorService executors;
    private List<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
    private static final Integer BATCH_SEND_SIZE = 1000;
    private ReentrantLock reentrantLock = new ReentrantLock();

    public DorisMessageSender(String tableName, MqMessageProduct compensateMsgProduct, StorageInfo storageInfo, List<String> columnList) {
        this.tableName = tableName;
        this.compensateMsgProduct = compensateMsgProduct;
        this.columnList = columnList;
        StreamUtils.JdbcInfo jdbcInfo = StreamUtils.extractInfoFromJdbcUrl(storageInfo.getAddr());
        Integer port = null != storageInfo.getPort() ? storageInfo.getPort() : DEFAULT_PORT;
        this.dataBaseName = jdbcInfo.getDbName();
        this.dorisStreamLoad = new DorisStreamLoad(jdbcInfo.getIp(), storageInfo.getUser(), storageInfo.getPwd(), port.intValue());
        this.executors = Executors.newVirtualThreadPerTaskExecutor();
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.scheduleAtFixedRate(this::flush, 1000L, 3000L, TimeUnit.MILLISECONDS);
    }

    private void flush() {
        if (this.reentrantLock.tryLock()) {
            try {
                this.dorisStreamLoad.sendData(this.dataBaseName, this.tableName, this.columnList, this.dataList);
                this.dataList.clear();
            }
            catch (Exception e) {
                log.error("flush data error", (Throwable)e);
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
    }

    @Override
    public Boolean send(Map<String, Object> data) throws Exception {
        try {
            log.info("dataBaseName:{},tableName:{},columnList:{},data:{}", new Object[]{this.dataBaseName, this.tableName, this.columnList, Constant.GSON.toJson(data)});
            this.reentrantLock.lock();
            this.dataList.add(data);
            if (this.dataList.size() > BATCH_SEND_SIZE) {
                List<Map<String, Object>> subList = this.dataList.subList(0, BATCH_SEND_SIZE);
                this.dorisStreamLoad.sendData(this.dataBaseName, this.tableName, this.columnList, subList);
                subList.clear();
            }
        }
        finally {
            this.reentrantLock.unlock();
        }
        return true;
    }

    @Override
    public boolean compensateSend(MqMessageDTO compensateMsg) {
        if (null != this.compensateMsgProduct) {
            this.compensateMsgProduct.product(compensateMsg);
            return true;
        }
        return false;
    }
}

