/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j;

import java.io.FileNotFoundException;
import java.io.IOException;
import net.sourceforge.pinyin4j.ResourceHelper;
import net.sourceforge.pinyin4j.multipinyin.Trie;

class ChineseToPinyinResource {
    private Trie unicodeToHanyuPinyinTable = null;

    private void setUnicodeToHanyuPinyinTable(Trie unicodeToHanyuPinyinTable) {
        this.unicodeToHanyuPinyinTable = unicodeToHanyuPinyinTable;
    }

    Trie getUnicodeToHanyuPinyinTable() {
        return this.unicodeToHanyuPinyinTable;
    }

    private ChineseToPinyinResource() {
        this.initializeResource();
    }

    private void initializeResource() {
        try {
            String resourceName = "/pinyindb/unicode_to_hanyu_pinyin.txt";
            String resourceMultiName = "/pinyindb/multi_pinyin.txt";
            this.setUnicodeToHanyuPinyinTable(new Trie());
            this.getUnicodeToHanyuPinyinTable().load(ResourceHelper.getResourceInputStream("/pinyindb/unicode_to_hanyu_pinyin.txt"));
            this.getUnicodeToHanyuPinyinTable().loadMultiPinyin(ResourceHelper.getResourceInputStream("/pinyindb/multi_pinyin.txt"));
            this.getUnicodeToHanyuPinyinTable().loadMultiPinyinExtend();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    Trie getHanyuPinyinTrie(char ch) {
        String codepointHexStr = Integer.toHexString(ch).toUpperCase();
        return this.getUnicodeToHanyuPinyinTable().get(codepointHexStr);
    }

    String[] getHanyuPinyinStringArray(char ch) {
        String pinyinRecord = this.getHanyuPinyinRecordFromChar(ch);
        return this.parsePinyinString(pinyinRecord);
    }

    String[] parsePinyinString(String pinyinRecord) {
        if (null != pinyinRecord) {
            int indexOfLeftBracket = pinyinRecord.indexOf("(");
            int indexOfRightBracket = pinyinRecord.lastIndexOf(")");
            String stripedString = pinyinRecord.substring(indexOfLeftBracket + "(".length(), indexOfRightBracket);
            return stripedString.split(",");
        }
        return null;
    }

    private boolean isValidRecord(String record) {
        String noneStr = "(none0)";
        return null != record && !record.equals("(none0)") && record.startsWith("(") && record.endsWith(")");
    }

    private String getHanyuPinyinRecordFromChar(char ch) {
        char codePointOfChar = ch;
        String codepointHexStr = Integer.toHexString(codePointOfChar).toUpperCase();
        Trie trie = this.getUnicodeToHanyuPinyinTable().get(codepointHexStr);
        String foundRecord = null;
        if (trie != null) {
            foundRecord = trie.getPinyin();
        }
        return this.isValidRecord(foundRecord) ? foundRecord : null;
    }

    static ChineseToPinyinResource getInstance() {
        return ChineseToPinyinResourceHolder.theInstance;
    }

    class Field {
        static final String LEFT_BRACKET = "(";
        static final String RIGHT_BRACKET = ")";
        static final String COMMA = ",";

        Field() {
        }
    }

    private static class ChineseToPinyinResourceHolder {
        static final ChineseToPinyinResource theInstance = new ChineseToPinyinResource();

        private ChineseToPinyinResourceHolder() {
        }
    }
}

