/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.QualityMarketService;
import org.apache.ozhera.monitor.service.model.QualityMarketQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class QualityMarketController {
    private static final Logger log = LoggerFactory.getLogger(QualityMarketController.class);
    @Autowired
    QualityMarketService qualityMarketService;

    @PostMapping(value={"/qualityMarket/mimonitor/createMarket"})
    public Result createQualityMarket(HttpServletRequest request, @RequestBody QualityMarketQuery param) {
        log.info("qualityMarket.createMarket : {} ", (Object)param);
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getMarketName()) && StringUtils.isNotEmpty((CharSequence)param.getServiceList())) {
            return this.qualityMarketService.createMarket(user, param.getMarketName(), param.getServiceList(), param.getRemark());
        }
        return Result.fail((ErrorCode)ErrorCode.RequestBodyIsEmpty);
    }

    @GetMapping(value={"/qualityMarket/mimonitor/searchMarket"})
    public Result searchQualityMarket(HttpServletRequest request, Integer primaryId) {
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (primaryId != null && primaryId != 0) {
            return this.qualityMarketService.searchMarket(user, primaryId.intValue());
        }
        return Result.fail((ErrorCode)ErrorCode.ScrapeIdIsEmpty);
    }

    @PostMapping(value={"/qualityMarket/mimonitor/updateMarket"})
    public Result updateQualityMarket(HttpServletRequest request, @RequestBody QualityMarketQuery param) {
        log.info("qualityMarket.updateQualityMarket : {} ", (Object)param);
        Integer id = param.getId();
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (id != null && id != 0 && StringUtils.isNotEmpty((CharSequence)param.getMarketName())) {
            return this.qualityMarketService.updateMarket(user, id.intValue(), param.getServiceList(), param.getMarketName(), param.getRemark());
        }
        return Result.fail((ErrorCode)ErrorCode.invalidParamError);
    }

    @PostMapping(value={"/qualityMarket/mimonitor/deleteMarket"})
    public Result deleteQualityMarket(HttpServletRequest request, Integer primaryId) {
        log.info("qualityMarket.deleteQualityMarket id:{} ", (Object)primaryId);
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (primaryId != null && primaryId != 0) {
            return this.qualityMarketService.deleteMarket(user, primaryId);
        }
        return Result.fail((ErrorCode)ErrorCode.invalidParamError);
    }

    @GetMapping(value={"/qualityMarket/mimonitor/searchMarketList"})
    public Result searchMarketList(HttpServletRequest request, Integer pageSize, Integer page, String creator, String marketName, String serviceName) {
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        if (page == 0) {
            page = 1;
        }
        return this.qualityMarketService.searchMarketList(user, pageSize.intValue(), page.intValue(), creator, marketName, serviceName);
    }

    public String checkUser(HttpServletRequest request) {
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            return "";
        }
        return userInfo.genFullAccount();
    }
}

