/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.controller.ScrapeJobController;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.extension.PlatFormTypeExtensionService;
import org.apache.ozhera.monitor.service.model.prometheus.CreateTemplateParam;
import org.apache.ozhera.monitor.service.prometheus.GrafanaTemplateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GrafanaTemplateController {
    private static final Logger log = LoggerFactory.getLogger(GrafanaTemplateController.class);
    @Autowired
    GrafanaTemplateService grafanaTemplateService;
    @Autowired
    ScrapeJobController scrapeJobController;
    @Autowired
    PlatFormTypeExtensionService platFormTypeExtensionService;

    @PostMapping(value={"/mimonitor/createTemplate"})
    public Result createTemplate(HttpServletRequest request, @RequestBody CreateTemplateParam param) {
        if (!param.check() || !this.platFormTypeExtensionService.checkTypeCode(param.getPlatform())) {
            log.info("createTemplate param error :{}", (Object)param);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        String user = this.scrapeJobController.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        return this.grafanaTemplateService.createGrafanaTemplate(param);
    }

    @PostMapping(value={"/mimonitor/deleteTemplate"})
    public Result deleteTemplate(HttpServletRequest request, Integer id) {
        String user = this.scrapeJobController.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        return this.grafanaTemplateService.deleteGrafanaTemplate(id.intValue());
    }

    @GetMapping(value={"/mimonitor/getTemplate"})
    public Result getTemplate(HttpServletRequest request, Integer id) {
        String user = this.scrapeJobController.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        return this.grafanaTemplateService.getGrafanaTemplate(id.intValue());
    }

    @PostMapping(value={"/mimonitor/updateTemplate"})
    public Result updateTemplate(HttpServletRequest request, @RequestBody CreateTemplateParam param) {
        if (!param.check()) {
            log.info("updateTemplate param error :{}", (Object)param);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        String user = this.scrapeJobController.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        return this.grafanaTemplateService.updateGrafanaTemplate(param);
    }

    @GetMapping(value={"/mimonitor/listTemplate"})
    public Result listTemplate(HttpServletRequest request, Integer pageSize, Integer page) {
        String user = this.scrapeJobController.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        if (page == null || page == 0) {
            page = 1;
        }
        return this.grafanaTemplateService.listGrafanaTemplate(pageSize.intValue(), page.intValue());
    }
}

