/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.google.common.collect.Lists;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.app.api.model.HeraAppRoleModel;
import org.apache.ozhera.monitor.bo.AppType;
import org.apache.ozhera.monitor.bo.Pair;
import org.apache.ozhera.monitor.dao.HeraAppRoleDao;
import org.apache.ozhera.monitor.dao.model.AlarmHealthQuery;
import org.apache.ozhera.monitor.dao.model.AppMonitor;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AppMonitorService;
import org.apache.ozhera.monitor.service.ComputeTimerService;
import org.apache.ozhera.monitor.service.HeraBaseInfoService;
import org.apache.ozhera.monitor.service.api.AppMonitorServiceExtension;
import org.apache.ozhera.monitor.service.extension.PlatFormTypeExtensionService;
import org.apache.ozhera.monitor.service.model.AppMonitorModel;
import org.apache.ozhera.monitor.service.model.AppMonitorRequest;
import org.apache.ozhera.monitor.service.model.HeraAppBaseQuery;
import org.apache.ozhera.monitor.service.model.HeraAppRoleQuery;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.redis.AppAlarmData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AppMonitorController {
    private static final Logger log = LoggerFactory.getLogger(AppMonitorController.class);
    @Autowired
    AppMonitorService appMonitorService;
    @Autowired
    ComputeTimerService computeTimerService;
    @Autowired
    HeraBaseInfoService heraBaseInfoService;
    @Autowired
    AppMonitorServiceExtension appMonitorServiceExtension;
    @Autowired
    private PlatFormTypeExtensionService platFormTypeExtensionService;
    @Autowired
    HeraAppRoleDao heraAppRoleDao;

    @GetMapping(value={"/mimonitor/resourceUsage"})
    public Result getResourceUsageUrl(Integer appId, String appName) {
        return this.appMonitorServiceExtension.getResourceUsageUrl(appId, appName);
    }

    @GetMapping(value={"/mimonitor/resourceUsagek8s"})
    public Result resourceUsagek8s(Integer appId, String appName) {
        return this.appMonitorService.getResourceUsageUrlForK8s(appId, appName);
    }

    @ResponseBody
    @GetMapping(value={"/mimonitor/getAppType"})
    public Result getAppType(Integer id) {
        HeraAppBaseInfoModel baseInfoModel = this.heraBaseInfoService.getById(id);
        log.info("getAppType id : {},result :{}", (Object)id, (Object)baseInfoModel);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("type", baseInfoModel == null ? AppType.businessType.getCode() : baseInfoModel.getAppType());
        return Result.success(map);
    }

    @ResponseBody
    @GetMapping(value={"/mimonitor/addHeraRoleM"})
    public Result addRoleByAppIdAndPlat(String appId, Integer plat, String user) {
        HeraAppRoleModel role = new HeraAppRoleModel();
        role.setAppId(appId);
        role.setAppPlatform(plat);
        role.setUser(user);
        role.setStatus(Integer.valueOf(1));
        role.setRole(Integer.valueOf(0));
        role.setCreateTime(new Date());
        role.setUpdateTime(new Date());
        return this.heraBaseInfoService.addRole(role);
    }

    @ResponseBody
    @GetMapping(value={"/mimonitor/addHeraRole"})
    public Result addHeraRole(HeraAppRoleModel role) {
        return this.heraBaseInfoService.addRole(role);
    }

    @ResponseBody
    @GetMapping(value={"/mimonitor/delHeraRole"})
    public Result delHeraRole(Integer id) {
        return this.heraBaseInfoService.delRole(id);
    }

    @ResponseBody
    @GetMapping(value={"/mimonitor/queryHeraRole"})
    public Result queryHeraRole(HeraAppRoleQuery query) {
        log.info("queryHeraRole query:{}", (Object)query);
        return this.heraBaseInfoService.queryRole(query.getModel(), query.getPage(), query.getPageSize());
    }

    @ResponseBody
    @GetMapping(value={"/mimonitor/getAppTypeByName"})
    public Result getAppType(Integer projectId, String projectName) {
        HeraAppBaseInfoModel byBindIdAndName = this.heraBaseInfoService.getByBindIdAndName(String.valueOf(projectId), projectName);
        log.info("getAppType projectId : {},projectName{},result :{}", new Object[]{projectId, projectName, byBindIdAndName});
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("type", byBindIdAndName == null ? AppType.businessType.getCode() : byBindIdAndName.getAppType());
        return Result.success(map);
    }

    @ResponseBody
    @PostMapping(value={"/mimonitor/appAlarmHealth"})
    public Result selectAppAlarmHealth(HttpServletRequest request, @RequestBody AlarmHealthQuery param) {
        log.info("AppMonitorController.selectAppAlarmHealth param : {}", (Object)param);
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            log.info("AppMonitorController.selectAppAlarmHealth request info error no user info found! ");
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        param.setOwner(userInfo.genFullAccount());
        return this.appMonitorService.selectAppAlarmHealth(param);
    }

    @ResponseBody
    @PostMapping(value={"/mimonitor/statistics"})
    public Result<List<AppAlarmData>> getProjectStatistics(HttpServletRequest request, @RequestBody AppMonitorRequest param) {
        log.info("AppMonitorController.getProjectStatistics param : {}", (Object)param);
        if (param.getDuration() <= 0L || CollectionUtils.isEmpty((Collection)param.getProjectList())) {
            log.error("AppMonitorController.getProjectStatistics error! invalid param! param : {}", (Object)param);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        return this.computeTimerService.getProjectStatistics(param);
    }

    @ResponseBody
    @PostMapping(value={"/mimonitor/titlenum/statistics"})
    public Result<AppAlarmData> titlenumStatistics(HttpServletRequest request, @RequestBody AppMonitorRequest param) {
        log.info("AppMonitorController.titlenumStatistics param : {}", (Object)param);
        if (CollectionUtils.isEmpty((Collection)param.getProjectList()) || param.getStartTime() == null || param.getEndTime() == null) {
            log.error("AppMonitorController.titlenumStatistics error! invalid param! param : {}", (Object)param);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        AppAlarmData appAlarmData = this.computeTimerService.countAppMetricData(param);
        log.info("AppMonitorController.titlenumStatistics param : {},result : {}", (Object)param, (Object)appAlarmData);
        return Result.success((Object)appAlarmData);
    }

    @ResponseBody
    @PostMapping(value={"/mimonitor/heraApps"})
    public Result<PageData> getHeraApps(HttpServletRequest request, @RequestBody HeraAppBaseQuery query) {
        if (query == null) {
            log.error("AppMonitorController.getHeraApps error! invalid param! param : {}", (Object)query);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        log.info("AppMonitorController.getHeraApps param : {}", (Object)query);
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            log.info("AppMonitorController.getHeraApps no user info found! param : {} ", (Object)query);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        query.setParticipant(userInfo.genFullAccount());
        return this.heraBaseInfoService.queryByParticipant(query);
    }

    @ResponseBody
    @PostMapping(value={"/mimonitor/getProjects"})
    public Result<PageData> getProjectInfos(HttpServletRequest request, @RequestBody AppMonitorRequest param) {
        log.info("AppMonitorController.getProjectInfos param : {}", (Object)param);
        if (param == null || param.getViewType() == null) {
            log.error("AppMonitorController.getProjectInfos error! invalid param! param : {}", (Object)param);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        if (param.getArea() == null) {
            log.error("AppMonitorController.getProjectInfos error! no area param! param : {}", (Object)param);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            log.info("AppMonitorController.getProjectInfos for user request info error no user info found! param : {} ", (Object)param);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return this.appMonitorService.getProjectInfos(userInfo.genFullAccount(), param.getAppName(), param.getPage(), param.getPageSize());
    }

    @ResponseBody
    @GetMapping(value={"/mimonitor/getMyProjectIds"})
    public Result<PageData> getMyProjectIds(HttpServletRequest request, Integer area) {
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            log.info("AppMonitorController.getMyProjectIds request info error no user info found! ");
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        Result result = null;
        result = this.appMonitorService.getProjectInfos(userInfo.genFullAccount(), null, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        log.debug("getMyProjectIds,area:{},result:{}", (Object)area, (Object)result);
        if (ErrorCode.success.getCode() != result.getCode()) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        List list = (List)((PageData)result.getData()).getList();
        PageData objectPageData = new PageData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            objectPageData.setList((Object)Lists.newArrayList());
            return Result.success((Object)objectPageData);
        }
        List projectIds = list.stream().map(it -> it.getId()).collect(Collectors.toList());
        objectPageData.setList(projectIds);
        return Result.success((Object)objectPageData);
    }

    @PostMapping(value={"/mimonitor/listApp"})
    public Result<PageData<List<AppMonitor>>> listMyApp(HttpServletRequest request, @RequestBody AppMonitorRequest param) {
        try {
            if (param.getPageSize() == null) {
                param.setPageSize(Integer.valueOf(1000));
            }
            log.info("AppMonitorController.listApp param : {} ", (Object)param);
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AppMonitorController.listApp request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AppMonitorController.listApp param : {} ,user : {}", (Object)param, (Object)user);
            if (param.getViewType() == null) {
                if (param.getDistinct() != null && param.getDistinct() == 1) {
                    return this.appMonitorService.listAppDistinct(user, param.getAppName(), param.getPage(), param.getPageSize());
                }
                return this.appMonitorService.listApp(param.getAppName(), user, param.getPage(), param.getPageSize());
            }
            if (param.getViewType() != null && param.getViewType() == 1) {
                return this.appMonitorService.listMyCareApp(param.getAppName(), user, param.getPage(), param.getPageSize());
            }
            AppMonitor appMonitor = new AppMonitor();
            appMonitor.setProjectName(param.getAppName());
            appMonitor.setAppSource(param.getPlatFormType());
            return this.appMonitorService.listMyApp(appMonitor, user, param.getPage(), param.getPageSize());
        }
        catch (Exception e) {
            log.error("AppMonitorController.listApp param : {} ,exception :{}", new Object[]{param, e.getMessage(), e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @PostMapping(value={"/mimonitor/my_and_care_app_list"})
    public Result<PageData<List<AppMonitor>>> myAndCareAppList(HttpServletRequest request, @RequestBody AppMonitorRequest param) {
        try {
            param.qryInit();
            log.info("AppMonitorController.myAndCareAppList param : {} ", (Object)param);
            AuthUserVo userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AppMonitorController.myAndCareAppList request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AppMonitorController.myAndCareAppList param : {} ,user : {}", (Object)param, (Object)user);
            return this.appMonitorService.myAndCareAppList(user, param);
        }
        catch (Exception e) {
            log.error("AppMonitorController.myAndCareAppList param : {} ,exception :{}", new Object[]{param, e.getMessage(), e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @PostMapping(value={"/mimonitor/addApp"})
    public Result<String> addApp(HttpServletRequest request, @RequestBody List<AppMonitorModel> params) {
        log.info("AppMonitorController.addApp param : {} ", params);
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            log.info("AppMonitorController.addApp request info error no user info found! param : {} ", params);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        String user = userInfo.genFullAccount();
        AppMonitorModel param = params.get(0);
        log.info("AppMonitorController.addApp param : {} ,user : {}", (Object)param, (Object)user);
        Result result = this.appMonitorService.createWithBaseInfo(param, user);
        log.info("AppMonitorController.addApp param : {} ,user : {} , result : {}", new Object[]{param, user, result});
        return result;
    }

    @GetMapping(value={"/mimonitor/delApp"})
    public Result<String> delApp(HttpServletRequest request, Integer id) {
        log.info("AppMonitorController.addApp id : {} ", (Object)id);
        return this.appMonitorService.delete(id);
    }

    @GetMapping(value={"/mimonitor/delAppByProjectId"})
    public Result<String> delAppByProjectId(HttpServletRequest request, Integer projectId, Integer appSource) {
        log.info("AppMonitorController.delAppByProjectId projectId : {} ,appSource : {}", (Object)projectId, (Object)appSource);
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            log.info("AppMonitorController.delAppByProjectId request error no user info found! projectId : {} ,appSource : {}", (Object)projectId, (Object)appSource);
            return Result.fail((ErrorCode)ErrorCode.INVALID_USER);
        }
        return this.appMonitorService.deleteByUser(projectId, appSource, userInfo.genFullAccount());
    }

    @GetMapping(value={"/mimonitor/platFormList"})
    public Result<List<Pair>> platFormList(HttpServletRequest request) {
        return Result.success((Object)this.platFormTypeExtensionService.getPlatFormTypeDescList());
    }

    @GetMapping(value={"/api-manual/deleteHeraApp"})
    public Result<String> deleteHeraApp(HttpServletRequest request, Integer id) {
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            log.info("AppMonitorController.deleteHeraApp request error no user info found! id : {}", (Object)id);
            return Result.fail((ErrorCode)ErrorCode.INVALID_USER);
        }
        log.info("AppMonitorController.deleteHeraApp id : {}", (Object)id);
        if (!userInfo.genFullAccount().equals("gaoxihui")) {
            return Result.fail((ErrorCode)ErrorCode.NoOperPermission);
        }
        this.heraBaseInfoService.deleAppById(id);
        return Result.success((Object)"sucess");
    }

    @GetMapping(value={"/mimonitor/appMembers"})
    public Result<List<String>> appMembers(HttpServletRequest request, String appId, Integer platForm) {
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            log.info("AppMonitorController.appMembers request error no user info found! appId : {}", (Object)appId);
            return Result.fail((ErrorCode)ErrorCode.INVALID_USER);
        }
        return this.heraBaseInfoService.getAppMembersByAppId(appId, platForm, userInfo.genFullAccount());
    }

    @GetMapping(value={"/mimonitor/appTypeList"})
    public Result<List<Pair>> appTypeList(HttpServletRequest request) {
        return Result.success((Object)AppType.getCodeDescList());
    }

    @GetMapping(value={"/mimonitor/washBaseId"})
    public Result washBaseId(HttpServletRequest request) {
        this.appMonitorService.washBaseId();
        return Result.success((Object)"washBaseId OOOK!");
    }

    @GetMapping(value={"/mimonitor/grafanaInterfaceList"})
    public Result grafanaInterfaceList() {
        return this.appMonitorService.grafanaInterfaceList();
    }

    @GetMapping(value={"/mimonitor/listapp/iamId"})
    public Result listAppByIAMId(Integer iamId, Integer iamType) {
        log.info("AppMonitorController.listAppByIAMId param : iamId : " + iamId + " iamType : " + iamType);
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            log.info("AppMonitorController.listAppByIAMId request info error no user info found! ");
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        String userName = userInfo.genFullAccount();
        return this.appMonitorService.selectByIAMId(iamId, iamType, userName);
    }

    @GetMapping(value={"/mimonitor/historyInstance"})
    public Result historyInstance(String application, String startTime, String endTime) {
        if (StringUtils.isBlank((CharSequence)application) || StringUtils.isBlank((CharSequence)startTime) || StringUtils.isBlank((CharSequence)endTime)) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        log.info("AppMonitorController.historyInstance param : application : " + application + " startTime : " + startTime + " endTime : " + endTime);
        Long start = Long.parseLong(startTime) / 1000L;
        Long end = Long.parseLong(endTime) / 1000L;
        if (start >= end) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        application = application.replace("-", "_");
        Result result = this.appMonitorService.historyInstance(application, start, end);
        return result;
    }
}

