/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.gem.BeanMappingGem;
import org.mapstruct.ap.internal.gem.BuilderGem;
import org.mapstruct.ap.internal.gem.NullValueCheckStrategyGem;
import org.mapstruct.ap.internal.gem.NullValueMappingStrategyGem;
import org.mapstruct.ap.internal.gem.NullValuePropertyMappingStrategyGem;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.DelegatingOptions;
import org.mapstruct.ap.internal.model.source.MapperOptions;
import org.mapstruct.ap.internal.model.source.MappingControl;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class BeanMappingOptions
extends DelegatingOptions {
    private final SelectionParameters selectionParameters;
    private final BeanMappingGem beanMapping;

    public static BeanMappingOptions forInheritance(BeanMappingOptions beanMapping) {
        BeanMappingOptions options = new BeanMappingOptions(SelectionParameters.forInheritance(beanMapping.selectionParameters), beanMapping.beanMapping, beanMapping);
        return options;
    }

    public static BeanMappingOptions getInstanceOn(BeanMappingGem beanMapping, MapperOptions mapperOptions, ExecutableElement method, FormattingMessager messager, Types typeUtils, TypeFactory typeFactory) {
        if (beanMapping == null || !BeanMappingOptions.isConsistent(beanMapping, method, messager)) {
            BeanMappingOptions options = new BeanMappingOptions(null, null, mapperOptions);
            return options;
        }
        Objects.requireNonNull(method);
        Objects.requireNonNull(messager);
        Objects.requireNonNull(method);
        Objects.requireNonNull(typeUtils);
        Objects.requireNonNull(typeFactory);
        SelectionParameters selectionParameters = new SelectionParameters(beanMapping.qualifiedBy().get(), beanMapping.qualifiedByName().get(), beanMapping.resultType().getValue(), typeUtils);
        BeanMappingOptions options = new BeanMappingOptions(selectionParameters, beanMapping, mapperOptions);
        return options;
    }

    private static boolean isConsistent(BeanMappingGem gem, ExecutableElement method, FormattingMessager messager) {
        if (!(gem.resultType().hasValue() || gem.qualifiedBy().hasValue() || gem.qualifiedByName().hasValue() || gem.ignoreUnmappedSourceProperties().hasValue() || gem.nullValueCheckStrategy().hasValue() || gem.nullValuePropertyMappingStrategy().hasValue() || gem.nullValueMappingStrategy().hasValue() || gem.ignoreByDefault().hasValue() || gem.builder().hasValue())) {
            messager.printMessage((Element)method, Message.BEANMAPPING_NO_ELEMENTS, new Object[0]);
            return false;
        }
        return true;
    }

    private BeanMappingOptions(SelectionParameters selectionParameters, BeanMappingGem beanMapping, DelegatingOptions next) {
        super(next);
        this.selectionParameters = selectionParameters;
        this.beanMapping = beanMapping;
    }

    @Override
    public NullValueCheckStrategyGem getNullValueCheckStrategy() {
        return Optional.ofNullable(this.beanMapping).map(BeanMappingGem::nullValueCheckStrategy).filter(GemValue::hasValue).map(GemValue::getValue).map(NullValueCheckStrategyGem::valueOf).orElse(this.next().getNullValueCheckStrategy());
    }

    @Override
    public NullValuePropertyMappingStrategyGem getNullValuePropertyMappingStrategy() {
        return Optional.ofNullable(this.beanMapping).map(BeanMappingGem::nullValuePropertyMappingStrategy).filter(GemValue::hasValue).map(GemValue::getValue).map(NullValuePropertyMappingStrategyGem::valueOf).orElse(this.next().getNullValuePropertyMappingStrategy());
    }

    @Override
    public NullValueMappingStrategyGem getNullValueMappingStrategy() {
        return Optional.ofNullable(this.beanMapping).map(BeanMappingGem::nullValueMappingStrategy).filter(GemValue::hasValue).map(GemValue::getValue).map(NullValueMappingStrategyGem::valueOf).orElse(this.next().getNullValueMappingStrategy());
    }

    @Override
    public BuilderGem getBuilder() {
        return Optional.ofNullable(this.beanMapping).map(BeanMappingGem::builder).filter(GemValue::hasValue).map(GemValue::getValue).orElse(this.next().getBuilder());
    }

    @Override
    public MappingControl getMappingControl(Elements elementUtils) {
        return Optional.ofNullable(this.beanMapping).map(BeanMappingGem::mappingControl).filter(GemValue::hasValue).map(GemValue::getValue).map(mc -> MappingControl.fromTypeMirror(mc, elementUtils)).orElse(this.next().getMappingControl(elementUtils));
    }

    public SelectionParameters getSelectionParameters() {
        return this.selectionParameters;
    }

    public boolean isignoreByDefault() {
        return Optional.ofNullable(this.beanMapping).map(BeanMappingGem::ignoreByDefault).map(GemValue::get).orElse(false);
    }

    public List<String> getIgnoreUnmappedSourceProperties() {
        return Optional.ofNullable(this.beanMapping).map(BeanMappingGem::ignoreUnmappedSourceProperties).map(GemValue::get).orElse(Collections.emptyList());
    }

    public AnnotationMirror getMirror() {
        return Optional.ofNullable(this.beanMapping).map(BeanMappingGem::mirror).orElse(null);
    }

    @Override
    public boolean hasAnnotation() {
        return this.beanMapping != null;
    }
}

