/*
 * Decompiled with CFR 0.152.
 */
package run.mone.docean.plugin.k8s;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;

public abstract class ReconcileResourceEventHandler<T extends HasMetadata>
implements ResourceEventHandler<T> {
    public void onAdd(T t) {
        if (!this.addPredicated(t) || !this.predicated(t)) {
            return;
        }
        this.reconcile(t.getMetadata());
    }

    public void onDelete(T t, boolean b) {
        if (!this.deletePredicated(t) || !this.predicated(t)) {
            return;
        }
        this.reconcile(t.getMetadata());
    }

    public void onUpdate(T t, T t1) {
        if (!this.updatePredicated(t, t1) || !this.predicated(t1)) {
            return;
        }
        this.reconcile(t1.getMetadata());
    }

    public abstract void reconcile(ObjectMeta var1);

    public boolean predicated(T t) {
        return true;
    }

    public boolean updatePredicated(T oldObj, T newObj) {
        return true;
    }

    public boolean addPredicated(T t) {
        return true;
    }

    public boolean deletePredicated(T t) {
        return true;
    }
}

