/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.interceptor;

import org.nutz.dao.DaoException;
import org.nutz.dao.DaoInterceptor;
import org.nutz.dao.DaoInterceptorChain;
import org.nutz.lang.Stopwatch;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class DaoTimeInterceptor
implements DaoInterceptor {
    private static final Log log = Logs.get();

    @Override
    public void filter(DaoInterceptorChain chain) throws DaoException {
        Stopwatch sw = Stopwatch.begin();
        try {
            chain.doChain();
            sw.stop();
        }
        catch (Throwable throwable) {
            sw.stop();
            if (log.isDebugEnabled()) {
                log.debugf("time=%sms, sql=%s", sw.getDuration(), chain.getDaoStatement().toString());
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debugf("time=%sms, sql=%s", sw.getDuration(), chain.getDaoStatement().toString());
        }
    }
}

