/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.filter;

import com.xiaomi.mone.tpc.login.enums.UserTypeEnum;
import com.xiaomi.mone.tpc.login.filter.DoceanAuthCasFilter;
import com.xiaomi.mone.tpc.login.filter.DoceanAuthTokenFilter;
import com.xiaomi.mone.tpc.login.filter.DoceanFilter;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.youpin.docean.mvc.MvcContext;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoceanReqUserFilter
extends DoceanFilter {
    private static final Logger log = LoggerFactory.getLogger(DoceanReqUserFilter.class);
    private DoceanFilter casFilter = null;
    private DoceanFilter tokenFilter = null;
    private boolean devMode;
    private boolean innerAuth;
    private String userInfoPath;

    @Override
    public void init(Map<String, String> filterConfig) {
        this.devMode = Boolean.parseBoolean(filterConfig.get("devMode"));
        this.innerAuth = Boolean.parseBoolean(filterConfig.get("innerAuth"));
        this.userInfoPath = filterConfig.get("userInfoPath");
        if (StringUtils.isBlank((CharSequence)this.userInfoPath)) {
            this.userInfoPath = "/login/userinfo";
        }
        if (this.innerAuth) {
            this.casFilter = new DoceanAuthCasFilter();
            this.casFilter.init(filterConfig);
        } else {
            this.tokenFilter = new DoceanAuthTokenFilter();
            this.tokenFilter.init(filterConfig);
        }
    }

    @Override
    public boolean doFilter(MvcContext mvcContext) {
        if (this.devMode) {
            Object mockAccType;
            String mockAcc = (String)mvcContext.getHeaders().get("user");
            if (StringUtils.isBlank((CharSequence)mockAcc)) {
                mockAcc = "test";
            }
            if (StringUtils.isBlank((CharSequence)(mockAccType = (String)mvcContext.getHeaders().get("userType")))) {
                mockAccType = "" + UserTypeEnum.CAS_TYPE.getCode();
            }
            AuthUserVo authUserVo = new AuthUserVo();
            authUserVo.setUserType(Integer.parseInt((String)mockAccType));
            authUserVo.setAccount(mockAcc);
            authUserVo.setName(mockAcc);
            mvcContext.session().setAttribute("TPC_USER", (Object)authUserVo);
            return true;
        }
        boolean result = false;
        result = this.innerAuth ? this.casFilter.doFilter(mvcContext) : this.tokenFilter.doFilter(mvcContext);
        return result;
    }

    @Override
    public void destroy() {
        if (this.casFilter != null) {
            this.casFilter.destroy();
        }
        if (this.tokenFilter != null) {
            this.tokenFilter.destroy();
        }
    }
}

