/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.retry;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retry<T> {
    private static final Logger log = LoggerFactory.getLogger(Retry.class);
    private int num = 3;
    private Predicate<T> checkResultPredicate = res -> null != res;

    public Retry(int num, Predicate<T> checkResultPredicate) {
        this.num = num;
        this.checkResultPredicate = checkResultPredicate;
    }

    public Retry() {
    }

    public Optional<T> execute(ExCallable<T> callable) {
        for (int i = 0; i < this.num; ++i) {
            try {
                T res = callable.call();
                if (this.checkResultPredicate.test(res)) {
                    return Optional.of(res);
                }
                log.error("{} check result error:{}", (Object)(i + 1), res);
                continue;
            }
            catch (Throwable ex) {
                log.error("{} execute error:{}", (Object)(i + 1), (Object)ex.getMessage());
                try {
                    TimeUnit.MILLISECONDS.sleep(200L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return Optional.empty();
    }

    public void setNum(int num) {
        this.num = num;
    }

    public void setCheckResultPredicate(Predicate<T> checkResultPredicate) {
        this.checkResultPredicate = checkResultPredicate;
    }

    public static interface ExCallable<T> {
        public T call() throws Throwable;
    }
}

