/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.xiaomi.youpin.docean.adapter.DoubleDefaultAdapter;
import com.xiaomi.youpin.docean.adapter.IntegerDefaultAdapter;
import com.xiaomi.youpin.docean.adapter.LongDefaultAdapter;
import com.xiaomi.youpin.docean.common.MethodReq;
import com.xiaomi.youpin.docean.exception.DoceanException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInvoker {
    private static final Logger log = LoggerFactory.getLogger(MethodInvoker.class);
    private ConcurrentHashMap<String, FastMethod> methodCache = new ConcurrentHashMap();
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(Integer.class, (Object)new IntegerDefaultAdapter()).registerTypeAdapter(Double.class, (Object)new DoubleDefaultAdapter()).registerTypeAdapter(Long.class, (Object)new LongDefaultAdapter()).create();

    public Object invokeMethod(Object obj, Class clazz, String methodName, Object[] params) {
        try {
            Optional<Method> optional = MethodInvoker.getMethod(clazz, methodName, params.length);
            if (optional.isPresent()) {
                optional.get().setAccessible(true);
                if (optional.get().getParameterCount() != params.length) {
                    return null;
                }
                if (params.length == 0) {
                    return optional.get().invoke(obj, new Object[0]);
                }
                return optional.get().invoke(obj, params);
            }
        }
        catch (Throwable ex) {
            log.error("invokeMethod error:{} class:{} method:{}", new Object[]{ex.getMessage(), clazz.getName(), methodName});
        }
        return null;
    }

    public Object invokeFastMethod(Object obj, Class clazz, String methodName, Object[] params) {
        try {
            String key = String.valueOf(clazz) + "_" + methodName;
            FastMethod m = this.methodCache.get(key);
            if (null != m) {
                return m.invoke(obj, params);
            }
            Optional<Method> optional = MethodInvoker.getMethod(clazz, methodName);
            if (optional.isPresent()) {
                FastClass fastClass = FastClass.create((Class)clazz);
                FastMethod method = fastClass.getMethod(optional.get());
                this.methodCache.putIfAbsent(key, method);
                return method.invoke(obj, params);
            }
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
        }
        return null;
    }

    public Object invokeMethod(Object obj, Method method, Object[] params) {
        try {
            if (params.length == 0) {
                return method.invoke(obj, new Object[0]);
            }
            return method.invoke(obj, params);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage());
            throw new DoceanException(ex);
        }
    }

    public Object invokeFastMethod(Object obj, Method method, Object[] params) {
        try {
            String key = String.valueOf(obj.getClass()) + "_" + method.getName();
            FastMethod m = this.methodCache.get(key);
            if (null != m) {
                return m.invoke(obj, params);
            }
            FastClass fc = FastClass.create(obj.getClass());
            FastMethod fm = fc.getMethod(method);
            this.methodCache.putIfAbsent(key, fm);
            return fm.invoke(obj, params);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage());
            throw new DoceanException(ex);
        }
    }

    public Object invokeMethod(Object obj, String methodName, Object[] params) {
        try {
            Method method = obj.getClass().getMethod(methodName, (Class[])Arrays.stream(params).map(it -> it.getClass()).toArray(Class[]::new));
            if (params.length == 0) {
                return method.invoke(obj, new Object[0]);
            }
            return method.invoke(obj, params);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage());
            throw new DoceanException(ex);
        }
    }

    public static Optional<Method> getMethod(Class clazz, String methodName) {
        return Arrays.stream(clazz.getMethods()).filter(it -> it.getName().equals(methodName)).findAny();
    }

    public static Optional<Method> getMethod(Class clazz, String methodName, int paramNum) {
        return Arrays.stream(clazz.getMethods()).filter(it -> it.getName().equals(methodName) && it.getParameterCount() == paramNum).findAny();
    }

    public Object[] getMethodParams(Object obj, String methodName, JsonElement params) {
        Method method = MethodInvoker.getMethod(obj.getClass(), methodName).get();
        return this.getMethodParams(method, params);
    }

    public Object[] getMethodParams(Method method, JsonElement params) {
        Class<?>[] types = method.getParameterTypes();
        return this.getMethodParams(params, types, (String str) -> null);
    }

    public Object[] getMethodParams(JsonElement params, Class<?>[] types, Function<String, Object> function) {
        if (types.length == 0) {
            return new Object[0];
        }
        if (params.isJsonObject()) {
            return Stream.of(this.getObj(params, types[0], function)).toArray();
        }
        if (params.isJsonArray()) {
            JsonArray array = params.getAsJsonArray();
            return IntStream.range(0, types.length).mapToObj(i -> {
                JsonElement ele = array.get(i);
                return this.getObj(ele, types[i], function);
            }).collect(Collectors.toList()).toArray();
        }
        throw new DoceanException("getMethodParams error");
    }

    private Object getObj(JsonElement params, Class<?> type, Function<String, Object> function) {
        JsonObject obj;
        if (params.isJsonObject() && (obj = params.getAsJsonObject()).has("__type__") && obj.get("__type__").getAsString().equals("session")) {
            String name = obj.get("__name__").getAsString();
            return function.apply(name);
        }
        return gson.fromJson(params, type);
    }

    public static Class classForName(String name) {
        if (name.equals("com.xiaomi.youpin.docean.Mvc$LazyHolder")) {
            return null;
        }
        try {
            return Class.forName(name);
        }
        catch (Throwable e) {
            log.warn("classForName:{} error:{}", (Object)name, (Object)e.getMessage());
            return null;
        }
    }

    public static Class classForName(String name, ClassLoader classLoader) {
        if (name.equals("com.xiaomi.youpin.docean.Mvc$LazyHolder")) {
            return null;
        }
        try {
            if (null == classLoader) {
                return Class.forName(name);
            }
            return Class.forName(name, true, classLoader);
        }
        catch (Throwable e) {
            log.warn("classForName:{} error:{}", (Object)name, (Object)e.getMessage());
            return null;
        }
    }

    public static Object getInstance(Class clazz) {
        try {
            if (clazz.isInterface()) {
                return null;
            }
            Constructor constructor = clazz.getConstructor(new Class[0]);
            if (null != constructor) {
                return clazz.newInstance();
            }
        }
        catch (InstantiationException e) {
            log.error(e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            log.error(e.getMessage());
        }
        return null;
    }

    public static Optional<Annotation> getAnno(Class<?> clazz, List<Class<? extends Annotation>> list) {
        Annotation[] anns = clazz.getAnnotations();
        return Arrays.stream(anns).filter(a -> list.stream().filter(it -> a.annotationType().equals(it)).findAny().isPresent()).findAny();
    }

    public Object invokeMethod(MethodReq req, Object obj, BiFunction<Class[], byte[][], Object[]> fun) {
        return this.invokeMethod(req.getMethodName(), obj, req.getParamTypes(), req.getByteParams(), fun, true);
    }

    public Object invokeMethod(String methodName, Object obj, String[] types, byte[][] paramArray, BiFunction<Class[], byte[][], Object[]> fun, boolean fast) {
        try {
            if (types.length > 0) {
                Class[] clazzArray = (Class[])Arrays.stream(types).map(i -> {
                    if (i.equals("int")) {
                        return Integer.TYPE;
                    }
                    if (i.equals("long")) {
                        return Long.TYPE;
                    }
                    try {
                        return Class.forName(i);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DoceanException("class forName error:" + e.getMessage());
                    }
                }).toArray(Class[]::new);
                Object[] params = fun.apply(clazzArray, paramArray);
                return this.invokeFastMethod(obj, obj.getClass(), methodName, params);
            }
            Method method = obj.getClass().getMethod(methodName, new Class[0]);
            return method.invoke(obj, new Object[0]);
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)ex;
                Throwable e = ite.getTargetException();
                log.error(e.getMessage(), e);
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
            log.error(ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    public void clear() {
        this.methodCache.clear();
    }
}

