/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.parse;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.parse.AbstractLogParser;
import org.apache.ozhera.log.parse.LogParserData;
import org.apache.ozhera.log.parse.RegexLogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NginxLogParser
extends AbstractLogParser {
    private static final Logger log = LoggerFactory.getLogger(NginxLogParser.class);
    private RegexLogParser regexLogParser;

    public NginxLogParser(LogParserData parserData) {
        super(parserData);
        String regexParseScript = this.generateRegexFromNginxScript(parserData.getParseScript());
        parserData.setParseScript(regexParseScript);
        this.regexLogParser = new RegexLogParser(parserData);
    }

    @Override
    public Map<String, Object> doParse(String logData, String ip, Long lineNum, Long collectStamp, String fileName) {
        return this.regexLogParser.parse(logData, ip, lineNum, collectStamp, fileName);
    }

    @Override
    public Map<String, Object> doParseSimple(String logData, Long collectStamp) {
        return this.regexLogParser.doParseSimple(logData, collectStamp);
    }

    public String generateRegexFromNginxScript(String nginxFormatStr) {
        Pattern regexSpace = Pattern.compile("\\s");
        Pattern regexSpaceChar = Pattern.compile("\\\\[tnvfr]");
        Pattern regexSpacePlus = Pattern.compile("\\s+");
        Pattern regexVar = Pattern.compile("\\$\\{?[a-zA-Z0-9_]+\\}?");
        Pattern regexSVar = Pattern.compile("([\\[\\{\\(\"])(\\$\\{?[a-zA-Z0-9_]+\\}?)([\\]\\}\\)\"])");
        Pattern regexNginxConfBodyGroup = Pattern.compile("'(.*?)'");
        String varPlaceHolder = "__VAR_PLACE_HOLDER__";
        String svarPlaceholder = "__SVAR_PLACE_HOLDER__";
        Object bodyStr = "";
        Matcher bodyMatcher = regexNginxConfBodyGroup.matcher(nginxFormatStr);
        while (bodyMatcher.find()) {
            for (int i = 1; i <= bodyMatcher.groupCount(); ++i) {
                bodyStr = (String)bodyStr + bodyMatcher.group(i);
            }
        }
        Object valueRegex = "";
        valueRegex = regexSpace.matcher((CharSequence)bodyStr).replaceAll(" ");
        valueRegex = regexSpaceChar.matcher((CharSequence)valueRegex).replaceAll(" ");
        valueRegex = regexSVar.matcher((CharSequence)valueRegex).replaceAll("$1" + svarPlaceholder + "$3");
        valueRegex = regexVar.matcher((CharSequence)valueRegex).replaceAll(varPlaceHolder);
        valueRegex = NginxLogParser.escapeExprSpecialWord((String)valueRegex);
        valueRegex = regexSpacePlus.matcher((CharSequence)valueRegex).replaceAll("\\\\s+");
        valueRegex = ((String)valueRegex).replaceAll(svarPlaceholder, "(.*?)");
        valueRegex = ((String)valueRegex).replaceAll(varPlaceHolder, "(\\\\S*)");
        valueRegex = (String)valueRegex + "\\s*$";
        return valueRegex;
    }

    public static String escapeExprSpecialWord(String keyword) {
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            String[] fbsArr;
            for (String key : fbsArr = new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"}) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }

    @Override
    public List<String> parseLogData(String logData) throws Exception {
        return this.regexLogParser.parseLogData(logData);
    }
}

