/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import org.apache.ozhera.monitor.bo.AlertHistory;
import org.apache.ozhera.monitor.bo.AlertHistoryDetailed;
import org.apache.ozhera.monitor.bo.AlertHistoryParam;
import org.apache.ozhera.monitor.dao.AppMonitorDao;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AlertHistoryService;
import org.apache.ozhera.monitor.service.helper.AlertHelper;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.prometheus.AlarmService;
import org.apache.ozhera.monitor.utils.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AlertHistoryServiceImpl
implements AlertHistoryService {
    private static final Logger log = LoggerFactory.getLogger(AlertHistoryServiceImpl.class);
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private AlertHelper alertHelper;
    @Autowired
    private AppMonitorDao appMonitorDao;

    @Override
    public Result<PageData<List<AlertHistory>>> metricList(String user, AlertHistoryParam param) {
        PageData<List<AlertHistory>> pageData = new PageData<List<AlertHistory>>();
        pageData.setPage(param.getPage());
        pageData.setPageSize(param.getPageSize());
        pageData.setTotal(0L);
        HashSet<Integer> treeIdSet = null;
        if (param.getIamTreeId() != null) {
            treeIdSet = new HashSet<Integer>();
            treeIdSet.add(param.getIamTreeId());
        } else {
            treeIdSet = this.appMonitorDao.selectTreeIdByOwnerOrCareUser(user);
        }
        if (CollectionUtils.isEmpty(treeIdSet)) {
            return Result.success(pageData);
        }
        JsonObject labels = this.alertHelper.buildLabels(param);
        Long startTime = CommonUtil.toSeconds((Long)param.getStartTime());
        Long endTime = CommonUtil.toSeconds((Long)param.getEndTime());
        Result<PageData> pageResult = this.alarmService.queryLatestEvents(treeIdSet, param.getAlertStat(), param.getAlertLevel(), startTime, endTime, param.getPage(), param.getPageSize(), labels);
        if (pageResult.getData() != null) {
            pageData.setTotal(((PageData)pageResult.getData()).getTotal());
            pageData.setList(this.alertHelper.buildAlertHistoryList((JsonElement)((PageData)pageResult.getData()).getList()));
        }
        return Result.success(pageData);
    }

    @Override
    public Result<AlertHistoryDetailed> metricDetailed(String user, AlertHistoryParam param) {
        Result<JsonObject> dataResult = this.alarmService.getEventById(user, param.getIamTreeId(), param.getId());
        if (dataResult == null || dataResult.getData() == null) {
            return Result.fail((ErrorCode)ErrorCode.ALERT_NOT_FOUND);
        }
        return Result.success((Object)this.alertHelper.buildAlertHistoryDetailed((JsonObject)dataResult.getData()));
    }

    @Override
    public Result metricResolved(String user, AlertHistoryParam param) {
        Long startTime = CommonUtil.toSeconds((Long)param.getStartTime());
        Long endTime = CommonUtil.toSeconds((Long)param.getEndTime());
        Result<JsonObject> dataResult = this.alarmService.resolvedEvent(user, param.getIamTreeId(), param.getAlertName(), param.getComment(), startTime, endTime);
        if (dataResult == null || dataResult.getCode() != ErrorCode.success.getCode()) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success(null);
    }
}

