/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.es;

import com.google.gson.Gson;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.api.EsExtensionService;
import org.apache.ozhera.monitor.service.helper.ProjectHelper;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.middleware.DbInstanceQuery;
import org.apache.ozhera.monitor.service.model.prometheus.EsIndexDataType;
import org.apache.ozhera.monitor.service.model.prometheus.MetricDetail;
import org.apache.ozhera.monitor.service.model.prometheus.MetricDetailQuery;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnProperty(name={"metric.detail.datasource.property"}, havingValue="es")
public class EsService {
    private static final Logger log = LoggerFactory.getLogger(EsService.class);
    @Value(value="${es.query.timeout:1000}")
    private Long esQueryTimeOut;
    @Autowired
    private ProjectHelper projectHelper;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
    @Autowired
    private EsExtensionService esExtensionService;

    public Result query(MetricDetailQuery param, Integer page, Integer pageSize) throws IOException {
        String viewType;
        String exceptionTraceDomain = this.esExtensionService.getExceptionTraceDomain(param.getAppSource());
        Map<String, String> labels = param.convertEsParam(exceptionTraceDomain);
        String index = this.esExtensionService.getIndex(param);
        if (StringUtils.isEmpty((CharSequence)index)) {
            log.error("EsService.query error! esIndex is empty!");
            return null;
        }
        if (page == null || page == 0) {
            page = 1;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 100;
        }
        SearchRequest request = new SearchRequest(new String[]{index});
        SearchSourceBuilder sqb = new SearchSourceBuilder();
        if (!CollectionUtils.isEmpty(labels)) {
            BoolQueryBuilder qb = QueryBuilders.boolQuery();
            Set<Map.Entry<String, String>> entries = labels.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (StringUtils.isBlank((CharSequence)entry.getValue())) continue;
                if (entry.getKey().equals("url") && labels.get("type").equals("mysql")) {
                    WildcardQueryBuilder sqlqb = QueryBuilders.wildcardQuery((String)entry.getKey(), (String)(entry.getValue() + "*"));
                    qb.must((QueryBuilder)sqlqb);
                    continue;
                }
                MatchPhraseQueryBuilder mpq = QueryBuilders.matchPhraseQuery((String)entry.getKey(), (Object)entry.getValue());
                qb.must((QueryBuilder)mpq);
            }
            if (param.getStartTime() != null && param.getEndTime() != null) {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"timestamp").from((Object)param.getStartTime()).to((Object)param.getEndTime());
                qb.must((QueryBuilder)rangeQueryBuilder);
            }
            sqb.query((QueryBuilder)qb);
        }
        CountRequest countRequest = new CountRequest(new String[]{index});
        countRequest.source(sqb);
        Long count = this.esExtensionService.getEsClient(param.getAppSource()).count(countRequest);
        sqb.from((page - 1) * pageSize).size(pageSize.intValue()).timeout(new TimeValue(this.esQueryTimeOut.longValue()));
        sqb = sqb.sort("timestamp", SortOrder.DESC);
        request.source(sqb);
        SearchResponse sr = this.esExtensionService.getEsClient(param.getAppSource()).search(request);
        log.info("Es query index : {},labels : {}, result : {}", new Object[]{index, labels, sr});
        SearchHit[] results = sr.getHits().getHits();
        PageData pd = new PageData();
        pd.setPage(page);
        pd.setPageSize(pageSize);
        pd.setTotal(count);
        String string = viewType = param.getType() == null ? "ERROR-TYPE" : param.getType();
        String methodName = EsIndexDataType.http_client.name().equals(param.getType()) || EsIndexDataType.http.name().equals(param.getType()) || EsIndexDataType.dubbo_consumer.name().equals(param.getType()) || EsIndexDataType.dubbo_provider.name().equals(param.getType()) || EsIndexDataType.dubbo_sla.name().equals(param.getType()) || EsIndexDataType.grpc_client.name().equals(param.getType()) || EsIndexDataType.grpc_server.name().equals(param.getType()) || EsIndexDataType.thrift_client.name().equals(param.getType()) || EsIndexDataType.thrift_server.name().equals(param.getType()) || EsIndexDataType.apus_client.name().equals(param.getType()) || EsIndexDataType.apus_server.name().equals(param.getType()) || EsIndexDataType.redis.name().equals(param.getType()) ? param.getMethodName() : (EsIndexDataType.mysql.name().equals(param.getType()) || EsIndexDataType.oracle.name().equals(param.getType()) || EsIndexDataType.elasticsearch.name().equals(param.getType()) ? param.getSqlMethod() : "NO-Data");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectName", param.getProjectName());
        map.put("bisType", viewType);
        map.put("serverIp", param.getServerIp());
        map.put("methodName", methodName);
        map.put("totalCount", count);
        map.put("serviceName", param.getServiceName());
        map.put("area", param.getArea());
        map.put("serverEnv", param.getServerEnv());
        map.put("serverZone", param.getServerZone());
        map.put("clientProjectId", param.getClientProjectId());
        map.put("clientProjectName", param.getClientProjectName());
        map.put("clientEnv", param.getClientEnv());
        map.put("clientIp", param.getClientIp());
        if (EsIndexDataType.mysql.name().equals(param.getType()) || EsIndexDataType.oracle.name().equals(param.getType())) {
            map.put("sql", param.getSql());
            map.put("dataSource", param.getDataSource());
        }
        if (results == null || results.length == 0) {
            pd.setSummary(map);
            return Result.success(pd);
        }
        ArrayList<MetricDetail> result = new ArrayList<MetricDetail>();
        for (SearchHit hit : results) {
            String sourceAsString = hit.getSourceAsString();
            if (StringUtils.isEmpty((CharSequence)sourceAsString)) continue;
            MetricDetail metricDetail = (MetricDetail)new Gson().fromJson(sourceAsString, MetricDetail.class);
            if (!StringUtils.isEmpty((CharSequence)metricDetail.getTimestamp())) {
                metricDetail.setCreateTime(Long.valueOf(metricDetail.getTimestamp()));
            }
            result.add(metricDetail);
        }
        String lastCreateTime = "";
        if (!CollectionUtils.isEmpty(result)) {
            MetricDetail metricDetail = (MetricDetail)result.get(result.size() - 1);
            lastCreateTime = metricDetail.getTimestamp();
        }
        if (!StringUtils.isEmpty((CharSequence)lastCreateTime)) {
            map.put("lastCreateTime", Long.valueOf(lastCreateTime));
        }
        if ("error".equals(param.getErrorType()) && this.projectHelper.accessLogSys(param.getProjectName(), param.getProjectId(), param.getAppSource())) {
            map.put("access_log", "1");
        }
        pd.setSummary(map);
        pd.setList(result);
        return Result.success(pd);
    }

    public Result queryMiddlewareInstance(DbInstanceQuery param, Integer page, Integer pageSize) throws IOException {
        return this.esExtensionService.queryMiddlewareInstance(param, page, pageSize, this.esQueryTimeOut);
    }
}

