/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Date;
import java.util.List;
import org.apache.ozhera.monitor.dao.mapper.AppScrapeJobMapper;
import org.apache.ozhera.monitor.dao.model.AppScrapeJob;
import org.apache.ozhera.monitor.dao.model.AppScrapeJobExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AppScrapeJobDao {
    private static final Logger log = LoggerFactory.getLogger(AppScrapeJobDao.class);
    @Autowired
    private AppScrapeJobMapper appScrapeJobMapper;

    public int insertScrapeJob(AppScrapeJob appScrapeJob) {
        appScrapeJob.setCreateTime(new Date());
        appScrapeJob.setUpdateTime(new Date());
        try {
            int result = this.appScrapeJobMapper.insert(appScrapeJob);
            if (result < 0) {
                log.warn("[AppScrapeJobDao.insert] failed to insert AppScrapeJobDao: {}", (Object)appScrapeJob.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AppScrapeJobDao.insert] failed to insert AppScrapeJobDao: {}, err: {}", (Object)appScrapeJob.toString(), (Object)e);
            return 0;
        }
        return 1;
    }

    public AppScrapeJob searchScrapeJob(Integer id) {
        try {
            AppScrapeJob result = this.appScrapeJobMapper.selectByPrimaryKey(id);
            if (result == null) {
                log.warn("[AppScrapeJobDao.search] failed to search AppScrapeJobDao id: {}", (Object)id);
            }
            return result;
        }
        catch (Exception e) {
            log.error("[AppScrapeJobDao.search] failed to search err: {} ,id: {}", (Object)e, (Object)id);
            return null;
        }
    }

    public List<AppScrapeJob> searchScrapeJobList(int pageSize, int pageNo) {
        AppScrapeJobExample aje = new AppScrapeJobExample();
        aje.setOrderByClause("id desc");
        aje.setLimit(pageSize);
        aje.setOffset((pageNo - 1) * pageSize);
        aje.createCriteria().andStatusEqualTo((byte)1);
        try {
            List<AppScrapeJob> list = this.appScrapeJobMapper.selectByExampleWithBLOBs(aje);
            if (list == null) {
                log.warn("[AppScrapeJobDao.searchScrapeJobList] failed to search");
            }
            return list;
        }
        catch (Exception e) {
            log.error("[AppScrapeJobDao.searchScrapeJobList] failed to search err: {}", (Object)e.toString());
            return null;
        }
    }

    public Long getJobSuccessTotal() {
        AppScrapeJobExample aje = new AppScrapeJobExample();
        aje.createCriteria().andStatusEqualTo((byte)1);
        try {
            Long result = this.appScrapeJobMapper.countByExample(aje);
            if (result == null) {
                log.warn("[AppScrapeJobDao.searchScrapeJobList] failed to search");
            }
            return result;
        }
        catch (Exception e) {
            log.error("[AppScrapeJobDao.getJobSuccessTotal] failed to search err: {}", (Object)e.toString());
            return null;
        }
    }

    public int updateScrapeJob(AppScrapeJob appScrapeJob) {
        try {
            appScrapeJob.setUpdateTime(new Date());
            int result = this.appScrapeJobMapper.updateByPrimaryKeyWithBLOBs(appScrapeJob);
            if (result < 0) {
                log.warn("[AppScrapeJobDao.update] failed to update AppScrapeJob: {}", (Object)appScrapeJob);
                return 0;
            }
            return result;
        }
        catch (Exception e) {
            log.error("[AppScrapeJobDao.update] failed to update AppScrapeJob : {} err: {}", (Object)appScrapeJob, (Object)e);
            return 0;
        }
    }
}

