/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.schema.ValidateResult;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class IntegerSchema
extends JSONSchema {
    final boolean typed;
    final long minimum;
    final boolean exclusiveMinimum;
    final long maximum;
    final boolean exclusiveMaximum;
    final long multipleOf;

    IntegerSchema(JSONObject input) {
        super(input);
        this.typed = "integer".equalsIgnoreCase(input.getString("type")) || input.getBooleanValue("required");
        Object exclusiveMinimum = input.get("exclusiveMinimum");
        long minimum = input.getLongValue("minimum", Long.MIN_VALUE);
        if (exclusiveMinimum == Boolean.TRUE) {
            this.exclusiveMinimum = true;
            this.minimum = minimum;
        } else if (exclusiveMinimum instanceof Number) {
            this.exclusiveMinimum = true;
            this.minimum = input.getLongValue("exclusiveMinimum");
        } else {
            this.minimum = minimum;
            this.exclusiveMinimum = false;
        }
        long maximum = input.getLongValue("maximum", Long.MIN_VALUE);
        Object exclusiveMaximum = input.get("exclusiveMaximum");
        if (exclusiveMaximum == Boolean.TRUE) {
            this.exclusiveMaximum = true;
            this.maximum = maximum;
        } else if (exclusiveMaximum instanceof Number) {
            this.exclusiveMaximum = true;
            this.maximum = input.getLongValue("exclusiveMaximum");
        } else {
            this.exclusiveMaximum = false;
            this.maximum = maximum;
        }
        this.multipleOf = input.getLongValue("multipleOf", 0L);
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.Integer;
    }

    @Override
    public ValidateResult validate(Object value) {
        BigDecimal decimal;
        if (value == null) {
            return this.typed ? FAIL_INPUT_NULL : SUCCESS;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == Byte.class || valueClass == Short.class || valueClass == Integer.class || valueClass == Long.class || valueClass == BigInteger.class || valueClass == AtomicInteger.class || valueClass == AtomicLong.class) {
            long longValue;
            if (this.minimum != Long.MIN_VALUE) {
                longValue = ((Number)value).longValue();
                if (this.exclusiveMinimum ? longValue <= this.minimum : longValue < this.minimum) {
                    return new ValidateResult(false, this.exclusiveMinimum ? "exclusiveMinimum not match, expect >= %s, but %s" : "minimum not match, expect >= %s, but %s", this.minimum, value);
                }
            }
            if (this.maximum != Long.MIN_VALUE) {
                longValue = ((Number)value).longValue();
                if (this.exclusiveMaximum ? longValue >= this.maximum : longValue > this.maximum) {
                    return new ValidateResult(false, this.exclusiveMaximum ? "exclusiveMaximum not match, expect >= %s, but %s" : "maximum not match, expect >= %s, but %s", this.maximum, value);
                }
            }
            if (this.multipleOf != 0L && (longValue = ((Number)value).longValue()) % this.multipleOf != 0L) {
                return new ValidateResult(false, "multipleOf not match, expect multipleOf %s, but %s", this.multipleOf, (Number)value);
            }
            return SUCCESS;
        }
        if (value instanceof BigDecimal && (decimal = (BigDecimal)value).compareTo(new BigDecimal(decimal.toBigInteger())) == 0) {
            return SUCCESS;
        }
        return this.typed ? new ValidateResult(false, "expect type %s, but %s", new Object[]{JSONSchema.Type.Integer, valueClass}) : SUCCESS;
    }

    @Override
    public ValidateResult validate(long longValue) {
        if (this.minimum != Long.MIN_VALUE && (this.exclusiveMinimum ? longValue <= this.minimum : longValue < this.minimum)) {
            return new ValidateResult(false, this.exclusiveMinimum ? "exclusiveMinimum not match, expect >= %s, but %s" : "minimum not match, expect >= %s, but %s", this.minimum, longValue);
        }
        if (this.maximum != Long.MIN_VALUE && (this.exclusiveMaximum ? longValue >= this.maximum : longValue > this.maximum)) {
            return new ValidateResult(false, this.exclusiveMaximum ? "exclusiveMaximum not match, expect >= %s, but %s" : "maximum not match, expect >= %s, but %s", this.maximum, longValue);
        }
        if (this.multipleOf != 0L && longValue % this.multipleOf != 0L) {
            return new ValidateResult(false, "multipleOf not match, expect multipleOf %s, but %s", this.multipleOf, longValue);
        }
        return SUCCESS;
    }

    @Override
    public ValidateResult validate(Long value) {
        if (value == null) {
            return this.typed ? FAIL_INPUT_NULL : SUCCESS;
        }
        long longValue = value;
        if (this.minimum != Long.MIN_VALUE && (this.exclusiveMinimum ? longValue <= this.minimum : longValue < this.minimum)) {
            return new ValidateResult(false, this.exclusiveMinimum ? "exclusiveMinimum not match, expect >= %s, but %s" : "minimum not match, expect >= %s, but %s", this.minimum, value);
        }
        if (this.maximum != Long.MIN_VALUE && (this.exclusiveMaximum ? longValue >= this.maximum : longValue > this.maximum)) {
            return new ValidateResult(false, this.exclusiveMaximum ? "exclusiveMaximum not match, expect >= %s, but %s" : "maximum not match, expect >= %s, but %s", this.maximum, value);
        }
        if (this.multipleOf != 0L && longValue % this.multipleOf != 0L) {
            return new ValidateResult(false, "multipleOf not match, expect multipleOf %s, but %s", this.multipleOf, longValue);
        }
        return SUCCESS;
    }

    @Override
    public ValidateResult validate(Integer value) {
        if (value == null) {
            return this.typed ? FAIL_INPUT_NULL : SUCCESS;
        }
        long longValue = value.longValue();
        if (this.minimum != Long.MIN_VALUE && (this.exclusiveMinimum ? longValue <= this.minimum : longValue < this.minimum)) {
            return new ValidateResult(false, this.exclusiveMinimum ? "exclusiveMinimum not match, expect >= %s, but %s" : "minimum not match, expect >= %s, but %s", this.minimum, value);
        }
        if (this.maximum != Long.MIN_VALUE && (this.exclusiveMaximum ? longValue >= this.maximum : longValue > this.maximum)) {
            return new ValidateResult(false, this.exclusiveMaximum ? "exclusiveMaximum not match, expect >= %s, but %s" : "maximum not match, expect >= %s, but %s", this.maximum, value);
        }
        if (this.multipleOf != 0L && longValue % this.multipleOf != 0L) {
            return new ValidateResult(false, "multipleOf not match, expect multipleOf %s, but %s", this.multipleOf, longValue);
        }
        return SUCCESS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerSchema that = (IntegerSchema)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description) && Objects.equals(this.minimum, that.minimum) && Objects.equals(this.exclusiveMinimum, that.exclusiveMinimum) && Objects.equals(this.maximum, that.maximum) && Objects.equals(this.exclusiveMaximum, that.exclusiveMaximum) && Objects.equals(this.multipleOf, that.multipleOf);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.minimum, this.exclusiveMinimum, this.maximum, this.exclusiveMaximum, this.multipleOf);
    }
}

