/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.ThreadlessExecutor;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.dubbo.FutureAdapter;
import org.apache.dubbo.rpc.support.RpcUtils;

public abstract class AbstractInvoker<T>
implements Invoker<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<T> type;
    private final URL url;
    private final Map<String, Object> attachment;
    private volatile boolean available = true;
    private AtomicBoolean destroyed = new AtomicBoolean(false);

    public AbstractInvoker(Class<T> type, URL url) {
        this(type, url, (Map<String, Object>)null);
    }

    public AbstractInvoker(Class<T> type, URL url, String[] keys) {
        this(type, url, AbstractInvoker.convertAttachment(url, keys));
    }

    public AbstractInvoker(Class<T> type, URL url, Map<String, Object> attachment) {
        if (type == null) {
            throw new IllegalArgumentException("service type == null");
        }
        if (url == null) {
            throw new IllegalArgumentException("service url == null");
        }
        this.type = type;
        this.url = url;
        this.attachment = attachment == null ? null : Collections.unmodifiableMap(attachment);
    }

    private static Map<String, Object> convertAttachment(URL url, String[] keys) {
        if (ArrayUtils.isEmpty(keys)) {
            return null;
        }
        HashMap<String, Object> attachment = new HashMap<String, Object>();
        for (String key : keys) {
            String value = url.getParameter(key);
            if (value == null || value.length() <= 0) continue;
            attachment.put(key, value);
        }
        return attachment;
    }

    @Override
    public Class<T> getInterface() {
        return this.type;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    protected void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public void destroy() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        this.setAvailable(false);
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public String toString() {
        return this.getInterface() + " -> " + (this.getUrl() == null ? "" : this.getUrl().toString());
    }

    @Override
    public Result invoke(Invocation inv) throws RpcException {
        AsyncRpcResult asyncResult;
        Map<String, Object> contextAttachments;
        if (this.destroyed.get()) {
            this.logger.warn("Invoker for service " + this + " on consumer " + NetUtils.getLocalHost() + " is destroyed, , dubbo version is " + Version.getVersion() + ", this invoker should not be used any longer");
        }
        RpcInvocation invocation = (RpcInvocation)inv;
        invocation.setInvoker(this);
        if (CollectionUtils.isNotEmptyMap(this.attachment)) {
            invocation.addObjectAttachmentsIfAbsent(this.attachment);
        }
        if (CollectionUtils.isNotEmptyMap(contextAttachments = RpcContext.getContext().getObjectAttachments())) {
            invocation.addObjectAttachments(contextAttachments);
        }
        invocation.setInvokeMode(RpcUtils.getInvokeMode(this.url, invocation));
        RpcUtils.attachInvocationIdIfAsync(this.getUrl(), invocation);
        Byte serializationId = CodecSupport.getIDByName(this.getUrl().getParameter("serialization", "hessian2"));
        if (serializationId != null) {
            invocation.put("serialization_id", serializationId);
        }
        try {
            asyncResult = (AsyncRpcResult)this.doInvoke(invocation);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te == null) {
                asyncResult = AsyncRpcResult.newDefaultAsyncResult(null, e, invocation);
            } else {
                if (te instanceof RpcException) {
                    ((RpcException)te).setCode(3);
                }
                asyncResult = AsyncRpcResult.newDefaultAsyncResult(null, te, invocation);
            }
        }
        catch (RpcException e) {
            if (e.isBiz()) {
                asyncResult = AsyncRpcResult.newDefaultAsyncResult(null, e, invocation);
            }
            throw e;
        }
        catch (Throwable e) {
            asyncResult = AsyncRpcResult.newDefaultAsyncResult(null, e, invocation);
        }
        RpcContext.getContext().setFuture(new FutureAdapter(asyncResult.getResponseFuture()));
        return asyncResult;
    }

    protected ExecutorService getCallbackExecutor(URL url, Invocation inv) {
        ExecutorService sharedExecutor = ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension().getExecutor(url);
        if (InvokeMode.SYNC == RpcUtils.getInvokeMode(this.getUrl(), inv)) {
            return new ThreadlessExecutor(sharedExecutor);
        }
        return sharedExecutor;
    }

    protected abstract Result doInvoke(Invocation var1) throws Throwable;
}

