/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CompatibleTypeUtils;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

public class CompatibleFilter
implements Filter,
Filter.Listener {
    private static Logger logger = LoggerFactory.getLogger(CompatibleFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return invoker.invoke(invocation);
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        Object value;
        if (!invocation.getMethodName().startsWith("$") && !appResponse.hasException() && (value = appResponse.getValue()) != null) {
            try {
                Object newValue;
                Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                Class<?> type = method.getReturnType();
                String serialization = invoker.getUrl().getParameter("serialization");
                if ("json".equals(serialization) || "fastjson".equals(serialization)) {
                    Type gtype = method.getGenericReturnType();
                    newValue = PojoUtils.realize(value, type, gtype);
                } else {
                    newValue = !type.isInstance(value) ? (PojoUtils.isPojo(type) ? PojoUtils.realize(value, type) : CompatibleTypeUtils.compatibleTypeConvert(value, type)) : value;
                }
                if (newValue != value) {
                    appResponse.setValue(newValue);
                }
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
        }
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }
}

