/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport;

import org.apache.dubbo.common.Parameters;
import org.apache.dubbo.common.Resetable;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Codec;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.transport.AbstractPeer;
import org.apache.dubbo.remoting.transport.codec.CodecAdapter;

public abstract class AbstractEndpoint
extends AbstractPeer
implements Resetable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEndpoint.class);
    private Codec2 codec;
    private int connectTimeout;

    public AbstractEndpoint(URL url, ChannelHandler handler) {
        super(url, handler);
        this.codec = AbstractEndpoint.getChannelCodec(url);
        this.connectTimeout = url.getPositiveParameter("connect.timeout", 3000);
    }

    protected static Codec2 getChannelCodec(URL url) {
        String codecName = url.getProtocol();
        if (ExtensionLoader.getExtensionLoader(Codec2.class).hasExtension(codecName)) {
            return ExtensionLoader.getExtensionLoader(Codec2.class).getExtension(codecName);
        }
        return new CodecAdapter(ExtensionLoader.getExtensionLoader(Codec.class).getExtension(codecName));
    }

    @Override
    public void reset(URL url) {
        if (this.isClosed()) {
            throw new IllegalStateException("Failed to reset parameters " + url + ", cause: Channel closed. channel: " + this.getLocalAddress());
        }
        try {
            int t;
            if (url.hasParameter("connect.timeout") && (t = url.getParameter("connect.timeout", 0)) > 0) {
                this.connectTimeout = t;
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        try {
            if (url.hasParameter("codec")) {
                this.codec = AbstractEndpoint.getChannelCodec(url);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    @Deprecated
    public void reset(Parameters parameters) {
        this.reset(this.getUrl().addParameters(parameters.getParameters()));
    }

    protected Codec2 getCodec() {
        return this.codec;
    }

    protected int getConnectTimeout() {
        return this.connectTimeout;
    }
}

