/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.SubscribedURLsSynthesizer;

public class RestProtocolSubscribedURLsSynthesizer
implements SubscribedURLsSynthesizer {
    @Override
    public boolean supports(URL subscribedURL) {
        return "rest".equals(subscribedURL.getProtocol()) || "rest".equals(subscribedURL.getParameter("protocol"));
    }

    @Override
    public List<URL> synthesize(URL subscribedURL, Collection<ServiceInstance> serviceInstances) {
        String protocol = subscribedURL.getParameter("protocol");
        return serviceInstances.stream().map(serviceInstance -> {
            URLBuilder urlBuilder = new URLBuilder().setProtocol(protocol).setHost(serviceInstance.getHost()).setPort(serviceInstance.getPort()).setPath(subscribedURL.getServiceInterface()).addParameter("side", "provider").addParameter("application", serviceInstance.getServiceName()).addParameter("register", Boolean.TRUE.toString());
            return urlBuilder.build();
        }).collect(Collectors.toList());
    }
}

