/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.monitor.support;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.monitor.Monitor;
import org.apache.dubbo.monitor.MonitorFactory;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"provider", "consumer"})
public class MonitorFilter
implements Filter,
Filter.Listener {
    private static final Logger logger = LoggerFactory.getLogger(MonitorFilter.class);
    private static final String MONITOR_FILTER_START_TIME = "monitor_filter_start_time";
    private static final String MONITOR_REMOTE_HOST_STORE = "monitor_remote_host_store";
    private final ConcurrentMap<String, AtomicInteger> concurrents = new ConcurrentHashMap<String, AtomicInteger>();
    private MonitorFactory monitorFactory;

    public void setMonitorFactory(MonitorFactory monitorFactory) {
        this.monitorFactory = monitorFactory;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (invoker.getUrl().hasParameter("monitor")) {
            invocation.put(MONITOR_FILTER_START_TIME, System.currentTimeMillis());
            invocation.put(MONITOR_REMOTE_HOST_STORE, RpcContext.getContext().getRemoteHost());
            this.getConcurrent(invoker, invocation).incrementAndGet();
        }
        return invoker.invoke(invocation);
    }

    private AtomicInteger getConcurrent(Invoker<?> invoker, Invocation invocation) {
        String key = invoker.getInterface().getName() + "." + invocation.getMethodName();
        return this.concurrents.computeIfAbsent(key, k -> new AtomicInteger());
    }

    @Override
    public void onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        if (invoker.getUrl().hasParameter("monitor")) {
            this.collect(invoker, invocation, result, (String)invocation.get(MONITOR_REMOTE_HOST_STORE), (Long)invocation.get(MONITOR_FILTER_START_TIME), false);
            this.getConcurrent(invoker, invocation).decrementAndGet();
        }
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        if (invoker.getUrl().hasParameter("monitor")) {
            this.collect(invoker, invocation, null, (String)invocation.get(MONITOR_REMOTE_HOST_STORE), (Long)invocation.get(MONITOR_FILTER_START_TIME), true);
            this.getConcurrent(invoker, invocation).decrementAndGet();
        }
    }

    private void collect(Invoker<?> invoker, Invocation invocation, Result result, String remoteHost, long start, boolean error) {
        try {
            URL monitorUrl = invoker.getUrl().getUrlParameter("monitor");
            Monitor monitor = this.monitorFactory.getMonitor(monitorUrl);
            if (monitor == null) {
                return;
            }
            URL statisticsURL = this.createStatisticsUrl(invoker, invocation, result, remoteHost, start, error);
            monitor.collect(statisticsURL);
        }
        catch (Throwable t) {
            logger.warn("Failed to monitor count service " + invoker.getUrl() + ", cause: " + t.getMessage(), t);
        }
    }

    private URL createStatisticsUrl(Invoker<?> invoker, Invocation invocation, Result result, String remoteHost, long start, boolean error) {
        String remoteValue;
        String remoteKey;
        int localPort;
        long elapsed = System.currentTimeMillis() - start;
        int concurrent = this.getConcurrent(invoker, invocation).get();
        String application = invoker.getUrl().getParameter("application");
        String service = invoker.getInterface().getName();
        String method = RpcUtils.getMethodName(invocation);
        String group = invoker.getUrl().getParameter("group");
        String version = invoker.getUrl().getParameter("version");
        if ("consumer".equals(invoker.getUrl().getParameter("side"))) {
            localPort = 0;
            remoteKey = "provider";
            remoteValue = invoker.getUrl().getAddress();
        } else {
            localPort = invoker.getUrl().getPort();
            remoteKey = "consumer";
            remoteValue = remoteHost;
        }
        String input = "";
        String output = "";
        if (invocation.getAttachment("input") != null) {
            input = invocation.getAttachment("input");
        }
        if (result != null && result.getAttachment("output") != null) {
            output = result.getAttachment("output");
        }
        return new URL("count", NetUtils.getLocalHost(), localPort, service + "/" + method, "application", application, "interface", service, "method", method, remoteKey, remoteValue, error ? "failure" : "success", "1", "elapsed", String.valueOf(elapsed), "concurrent", String.valueOf(concurrent), "input", input, "output", output, "group", group, "version", version);
    }
}

