/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import com.alibaba.spring.util.AnnotationUtils;
import java.util.Map;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DubboAnnotationUtils {
    @Deprecated
    public static String resolveInterfaceName(Service service, Class<?> defaultInterfaceClass) throws IllegalStateException {
        String interfaceName;
        if (StringUtils.hasText((String)service.interfaceName())) {
            interfaceName = service.interfaceName();
        } else if (!Void.TYPE.equals(service.interfaceClass())) {
            interfaceName = service.interfaceClass().getName();
        } else if (defaultInterfaceClass.isInterface()) {
            interfaceName = defaultInterfaceClass.getName();
        } else {
            throw new IllegalStateException("The @Service undefined interfaceClass or interfaceName, and the type " + defaultInterfaceClass.getName() + " is not a interface.");
        }
        return interfaceName;
    }

    public static String resolveInterfaceName(AnnotationAttributes attributes, Class<?> defaultInterfaceClass) {
        Boolean generic = (Boolean)AnnotationUtils.getAttribute((Map)attributes, (String)"generic");
        if (generic != null && generic.booleanValue()) {
            String interfaceClassName = (String)AnnotationUtils.getAttribute((Map)attributes, (String)"interfaceName");
            Assert.hasText((String)interfaceClassName, (String)"@Reference interfaceName() must be present when reference a generic service!");
            return interfaceClassName;
        }
        return DubboAnnotationUtils.resolveServiceInterfaceClass(attributes, defaultInterfaceClass).getName();
    }

    public static Class<?> resolveServiceInterfaceClass(AnnotationAttributes attributes, Class<?> defaultInterfaceClass) throws IllegalArgumentException {
        Class[] allInterfaces;
        ClassLoader classLoader = defaultInterfaceClass != null ? defaultInterfaceClass.getClassLoader() : Thread.currentThread().getContextClassLoader();
        Class interfaceClass = (Class)AnnotationUtils.getAttribute((Map)attributes, (String)"interfaceClass");
        if (Void.TYPE.equals(interfaceClass)) {
            interfaceClass = null;
            String interfaceClassName = (String)AnnotationUtils.getAttribute((Map)attributes, (String)"interfaceName");
            if (StringUtils.hasText((String)interfaceClassName) && ClassUtils.isPresent((String)interfaceClassName, (ClassLoader)classLoader)) {
                interfaceClass = ClassUtils.resolveClassName((String)interfaceClassName, (ClassLoader)classLoader);
            }
        }
        if (interfaceClass == null && defaultInterfaceClass != null && (allInterfaces = ClassUtils.getAllInterfacesForClass(defaultInterfaceClass)).length > 0) {
            interfaceClass = allInterfaces[0];
        }
        Assert.notNull((Object)interfaceClass, (String)"@Service interfaceClass() or interfaceName() or interface class must be present!");
        Assert.isTrue((boolean)interfaceClass.isInterface(), (String)"The annotated type must be an interface!");
        return interfaceClass;
    }

    @Deprecated
    public static String resolveInterfaceName(Reference reference, Class<?> defaultInterfaceClass) throws IllegalStateException {
        String interfaceName;
        if (!"".equals(reference.interfaceName())) {
            interfaceName = reference.interfaceName();
        } else if (!Void.TYPE.equals(reference.interfaceClass())) {
            interfaceName = reference.interfaceClass().getName();
        } else if (defaultInterfaceClass.isInterface()) {
            interfaceName = defaultInterfaceClass.getName();
        } else {
            throw new IllegalStateException("The @Reference undefined interfaceClass or interfaceName, and the type " + defaultInterfaceClass.getName() + " is not a interface.");
        }
        return interfaceName;
    }
}

