/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.client.bo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpReq
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(OkHttpReq.class);
    private List<Protocol> protocolList;

    public OkHttpReq(String protocol) {
        this.addProtocol(protocol);
    }

    public OkHttpReq() {
    }

    public void addProtocol(String protocol) {
        if (null == protocol || protocol.trim().equals("")) {
            return;
        }
        if (null == this.protocolList) {
            this.protocolList = new ArrayList<Protocol>();
        }
        try {
            this.protocolList.add(Protocol.valueOf((String)protocol));
        }
        catch (Throwable ex) {
            log.error(ex.getMessage());
            this.protocolList.add(Protocol.HTTP_1_1);
        }
    }

    public List<Protocol> getProtocolList() {
        return this.protocolList;
    }

    public void setProtocolList(List<Protocol> protocolList) {
        this.protocolList = protocolList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OkHttpReq)) {
            return false;
        }
        OkHttpReq other = (OkHttpReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Protocol> this$protocolList = this.getProtocolList();
        List<Protocol> other$protocolList = other.getProtocolList();
        return !(this$protocolList == null ? other$protocolList != null : !((Object)this$protocolList).equals(other$protocolList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OkHttpReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Protocol> $protocolList = this.getProtocolList();
        result = result * 59 + ($protocolList == null ? 43 : ((Object)$protocolList).hashCode());
        return result;
    }

    public String toString() {
        return "OkHttpReq(protocolList=" + String.valueOf(this.getProtocolList()) + ")";
    }
}

