/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientV5 {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientV5.class);
    private static boolean catEnabled;
    private static final String CAT_TYPE = "httpClient";
    static TrustManager[] trustAllCerts;

    public static void enableCat() {
        catEnabled = true;
    }

    public static void disableCat() {
        catEnabled = false;
    }

    public static String get(String url, Map<String, String> headers) {
        return HttpClientV5.get(url, headers, 500);
    }

    public static String get(String url, Map<String, String> headers, int readTimeout) {
        ArrayList list = Lists.newArrayList();
        if (null != headers) {
            headers.entrySet().stream().forEach(it -> {
                list.add((String)it.getKey());
                list.add((String)it.getValue());
            });
        }
        return HttpClientV5.httpGet((String)url, (List<String>)list, (Map<String, String>)Maps.newHashMap(), (String)"UTF-8", (int)readTimeout).content;
    }

    public static byte[] download(String url, int timeout, File file) {
        ArrayList list = Lists.newArrayList();
        HashMap map = Maps.newHashMap();
        HttpResult res = HttpClientV5.httpGet(url, list, map, "UTF-8", timeout, true, file);
        if (res.code != 200) {
            logger.warn("download:{} error:{}", (Object)url, (Object)res.code);
            return new byte[0];
        }
        return res.data;
    }

    public static byte[] download(String url, int timeout) {
        return HttpClientV5.download(url, timeout, null);
    }

    public static String upload(String url, byte[] data) {
        String res = HttpClientV5.post(url, data, (Map<String, String>)Maps.newHashMap(), 1000);
        logger.info("upload res:{}", (Object)res);
        return res;
    }

    public static HttpResult httpGet(String url, Map<String, String> headers) {
        ArrayList list = Lists.newArrayList();
        if (null != headers) {
            headers.entrySet().stream().forEach(it -> {
                list.add((String)it.getKey());
                list.add((String)it.getValue());
            });
        }
        return HttpClientV5.httpGet(url, list, Maps.newHashMap(), "UTF-8");
    }

    public static String post(String url, String body, Map<String, String> headers, int timeout) {
        return HttpClientV5.post(url, body.getBytes(), headers, timeout);
    }

    public static String post(String url, byte[] body, Map<String, String> headers, int timeout) {
        boolean success = true;
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            if (null != headers) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    conn.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            conn.addRequestProperty("Connection", "close");
            conn.getOutputStream().write(body);
            String string = new String(ByteStreams.toByteArray((InputStream)conn.getInputStream()));
            return string;
        }
        catch (Exception ex) {
            success = false;
            logger.warn("http client v2 error:{}", (Object)ex.getMessage());
            throw new RuntimeException(ex.getMessage());
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    public static String post(String url, String body, Map<String, String> headers) {
        return HttpClientV5.post(url, body, headers, 500);
    }

    public static HttpResult httpGet(String url, List<String> headers, Map<String, String> paramValues, String encoding) {
        return HttpClientV5.request(url, headers, paramValues, encoding, "GET");
    }

    public static HttpResult httpGet(String url, List<String> headers, Map<String, String> paramValues, String encoding, int readTimeout) {
        return HttpClientV5.request(url, headers, paramValues, encoding, "GET", readTimeout, false, null);
    }

    public static HttpResult httpGet(String url, List<String> headers, Map<String, String> paramValues, String encoding, int readTimeout, boolean download, File file) {
        return HttpClientV5.request(url, headers, paramValues, encoding, "GET", readTimeout, download, file);
    }

    public static HttpResult request(String url, List<String> headers, Map<String, String> paramValues, String encoding, String method) {
        return HttpClientV5.request(url, headers, paramValues, encoding, method, 500, false, null);
    }

    public static HttpResult request(String url, List<String> headers, Map<String, String> paramValues, String encoding, String method, boolean download, File file) {
        return HttpClientV5.request(url, headers, paramValues, encoding, method, 500, download, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult request(String url, List<String> headers, Map<String, String> paramValues, String encoding, String method, int readTimeout, boolean download, File file) {
        boolean success = true;
        HttpURLConnection conn = null;
        try {
            Object sc;
            String encodedContent = HttpClientV5.encodingParams(paramValues, encoding);
            url = (String)url + (String)(null == encodedContent ? "" : "?" + encodedContent);
            if (((String)url).startsWith("https")) {
                HttpsURLConnection.setDefaultHostnameVerifier(new NullHostNameVerifier());
                sc = SSLContext.getInstance("TLS");
                ((SSLContext)sc).init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(((SSLContext)sc).getSocketFactory());
                conn = (HttpURLConnection)new URL((String)url).openConnection();
            } else {
                conn = (HttpURLConnection)new URL((String)url).openConnection();
            }
            conn.setConnectTimeout(readTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setRequestMethod(method);
            HttpClientV5.setHeaders(conn, headers, encoding);
            conn.addRequestProperty("Connection", download ? "keep-alive" : "close");
            conn.connect();
            logger.debug("Request from server: " + (String)url);
            sc = HttpClientV5.getResult(conn, download, file);
            return sc;
        }
        catch (Exception e) {
            try {
                if (conn != null) {
                    logger.warn("failed to request " + String.valueOf(conn.getURL()) + " from " + InetAddress.getByName(conn.getURL().getHost()).getHostAddress());
                }
            }
            catch (Exception e1) {
                logger.warn("NA", (Object)"failed to request ", (Object)e1);
            }
            logger.warn("NA", (Object)"failed to request ", (Object)e);
            success = false;
            HttpResult httpResult = new HttpResult(500, e.toString(), Collections.emptyMap());
            return httpResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static HttpResult getResult(HttpURLConnection conn, boolean download, File file) throws IOException {
        int respCode = conn.getResponseCode();
        InputStream inputStream = 200 == respCode || 304 == respCode ? conn.getInputStream() : conn.getErrorStream();
        HashMap<String, String> respHeaders = new HashMap<String, String>(conn.getHeaderFields().size());
        for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
            respHeaders.put(entry.getKey(), entry.getValue().get(0));
        }
        String encodingGzip = "gzip";
        if (encodingGzip.equals(respHeaders.get("Content-Encoding"))) {
            inputStream = new GZIPInputStream(inputStream);
        }
        if (null != file) {
            boolean res = HttpClientV5.getBytes(inputStream, file);
            return new HttpResult(respCode, res ? "57" : "", respHeaders);
        }
        byte[] data = download ? HttpClientV5.getBytes(inputStream) : ByteStreams.toByteArray((InputStream)inputStream);
        HttpResult res = new HttpResult(respCode, new String(data, HttpClientV5.getCharset(conn)), respHeaders);
        res.data = data;
        return res;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = is.read(data)) != -1) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warn("interrupted");
                return new byte[0];
            }
            buffer.write(data, 0, nRead);
        }
        byte[] res = buffer.toByteArray();
        is.close();
        buffer.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBytes(InputStream is, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        byte[] data = new byte[8192];
        try {
            int len;
            while ((len = is.read(data)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    logger.warn("interrupted download:{}", (Object)file);
                    boolean bl = false;
                    return bl;
                }
                fos.write(data, 0, len);
            }
            fos.flush();
        }
        finally {
            is.close();
            fos.close();
        }
        return true;
    }

    private static String getCharset(HttpURLConnection conn) {
        String contentType = conn.getContentType();
        if (null == contentType || contentType.equals("")) {
            return "UTF-8";
        }
        String[] values = contentType.split(";");
        if (values.length == 0) {
            return "UTF-8";
        }
        String charset = "UTF-8";
        for (String value : values) {
            if (!(value = value.trim()).toLowerCase().startsWith("charset=")) continue;
            charset = value.substring("charset=".length());
        }
        return charset;
    }

    private static void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (null != headers) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Accept-Charset", encoding);
    }

    private static String encodingParams(Map<String, String> params, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == params || params.isEmpty()) {
            return null;
        }
        params.put("encoding", encoding);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (null == entry.getValue() || entry.getValue().equals("")) continue;
            sb.append(entry.getKey()).append("=");
            sb.append(URLEncoder.encode(entry.getValue(), encoding));
            sb.append("&");
        }
        return sb.toString();
    }

    static {
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
    }

    public static class HttpResult {
        public final int code;
        public final String content;
        public byte[] data;
        private final Map<String, String> respHeaders;

        public HttpResult(int code, String content, Map<String, String> respHeaders) {
            this.code = code;
            this.content = content;
            this.respHeaders = respHeaders;
        }

        public String getHeader(String name) {
            return this.respHeaders.get(name);
        }
    }

    public static class NullHostNameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }
}

