/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.nacos.impl;

import com.alibaba.nacos.api.config.ConfigService;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.nacos.DynamicConfigProvider;
import org.apache.ozhera.log.model.MilogSpaceData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceConfigNacosProvider
implements DynamicConfigProvider<MilogSpaceData> {
    private static final Logger log = LoggerFactory.getLogger(SpaceConfigNacosProvider.class);
    private ConfigService configService;

    @Override
    public MilogSpaceData getConfig(Long spaceId) {
        String dataId = CommonExtensionServiceFactory.getCommonExtensionService().getLogManagePrefix() + "create_tail_config:" + spaceId;
        try {
            String rules = this.configService.getConfig(dataId, "DEFAULT_GROUP", Constant.DEFAULT_TIME_OUT_MS.longValue());
            log.info("Query the log configuration in NACOS,dataId:{},data:{}", (Object)dataId, (Object)rules);
            if (StringUtils.isNotEmpty((CharSequence)rules)) {
                return (MilogSpaceData)gson.fromJson(rules, MilogSpaceData.class);
            }
        }
        catch (Exception e) {
            log.error(String.format("Query log configuration data data exceptions, parameters:%s", dataId), (Throwable)e);
        }
        return null;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }
}

