/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.manager.model.bo.RocketMqStatisticParam;

public interface CommonRocketMqService {
    public static final String authorization = Config.ins().get("rocketmq_authorization", "");
    public static final String clientVerify = Config.ins().get("rocketmq_x-ssl-client-verify", "");
    public static final String clientDn = Config.ins().get("rocketmq_x-ssl-client-dn", "");
    public static final String rocketmqAddress = Config.ins().get("rocketmq_address", "");
    public static final String rocketmqAk = Config.ins().get("rocketmq_ak", "");
    public static final String rocketmqSk = Config.ins().get("rocketmq_sk", "");
    public static final String rocketmqNamesrvAddr = Config.ins().get("rocketmq_namesrv_addr", "");
    public static final String rocketmqOrgId = Config.ins().get("rocketmq_org_id", "");
    public static final String userGroupIds = Config.ins().get("rocketmq_user_group_ids", "CI102316,CI102322");
    public static final List<String> brokers = Arrays.stream(Config.ins().get("rocketmq_brokers", "").split(",")).collect(Collectors.toList());
    public static final Integer queueEachBroker = 1;
    public static final Integer queueTotalCount = 1;
    public static final String METHOD_DELETE = "DELETE";
    public static final String MQ_AUTHORIZATION = "authorization";
    public static final String MQ_X_SSL_CLIENT_VERIFY = "x-ssl-client-verify";
    public static final String MQ_X_SSL_CLIENT_DN = "x-ssl-client-dn";
    public static final String MQ_ORG_ID = "orgId";
    public static final String MQ_NAME = "name";
    public static final String MQ_BROKERS = "brokers";
    public static final String MQ_QUEUEEACH_BROKER = "queueEachBroker";
    public static final String MQ_QUEUE_TOTAL_COUNT = "queueTotalCount";
    public static final String MQ_CONTENT_TYPE = "Content-Type";

    default public Map<String, String> getSendMqHeader(String userAuthorization) {
        HashMap headMap = Maps.newHashMap();
        if (StringUtils.isEmpty((CharSequence)userAuthorization)) {
            headMap.put(MQ_AUTHORIZATION, authorization);
        } else {
            headMap.put(MQ_AUTHORIZATION, userAuthorization);
        }
        headMap.put(MQ_X_SSL_CLIENT_VERIFY, clientVerify);
        headMap.put(MQ_X_SSL_CLIENT_DN, clientDn);
        headMap.put(MQ_CONTENT_TYPE, "application/json");
        return headMap;
    }

    default public List<String> getSendMqHeader2List(String authorization) {
        ArrayList lists = Lists.newArrayList();
        this.getSendMqHeader(authorization).entrySet().stream().forEach(map -> {
            lists.add((String)map.getKey());
            lists.add((String)map.getValue());
        });
        return lists;
    }

    default public String createTopicBodyParams(String topicName) {
        HashMap paramsMap = Maps.newHashMap();
        paramsMap.put(MQ_ORG_ID, rocketmqOrgId);
        paramsMap.put(MQ_NAME, topicName);
        paramsMap.put(MQ_BROKERS, brokers);
        paramsMap.put(MQ_QUEUEEACH_BROKER, queueEachBroker);
        paramsMap.put(MQ_QUEUE_TOTAL_COUNT, queueTotalCount);
        return new Gson().toJson((Object)paramsMap);
    }

    default public String createConsumerGroupParams(String name, String orgId) {
        HashMap paramsMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)orgId)) {
            paramsMap.put(MQ_ORG_ID, orgId);
        } else {
            paramsMap.put(MQ_ORG_ID, rocketmqOrgId);
        }
        paramsMap.put(MQ_NAME, name);
        return new Gson().toJson((Object)paramsMap);
    }

    default public String updateTopicAuthParams(String topicName) {
        HashMap paramsMap = Maps.newHashMap();
        paramsMap.put(MQ_NAME, topicName);
        ArrayList mapList = Lists.newArrayList();
        Arrays.stream(userGroupIds.split(",")).forEach(groupId -> {
            TreeMap<String, String> orgMap = new TreeMap<String, String>();
            orgMap.put("teamId", (String)groupId);
            orgMap.put("value", "PUB|SUB");
            mapList.add(orgMap);
        });
        paramsMap.put("teamPerms", mapList);
        System.out.println(new Gson().toJson((Object)paramsMap));
        return new Gson().toJson((Object)paramsMap);
    }

    default public String createTopicStatisticBodyParams(final String topic, String group, String broker, String aggregator, Long begin, Long end) {
        RocketMqStatisticParam rmqsc = new RocketMqStatisticParam();
        rmqsc.setTopicList((List<String>)new ArrayList<String>(){
            {
                this.add(topic);
            }
        });
        rmqsc.setBroker("*");
        rmqsc.setAggregator(aggregator);
        rmqsc.setBegin(begin);
        rmqsc.setEnd(end);
        return new Gson().toJson((Object)rmqsc);
    }
}

