/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.model.pojo;

import org.apache.ozhera.log.manager.model.BaseCommon;
import org.nutz.dao.entity.annotation.ColDefine;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Comment;
import org.nutz.dao.entity.annotation.Default;
import org.nutz.dao.entity.annotation.Id;
import org.nutz.dao.entity.annotation.Table;

@Table(value="milog_logstore")
@Comment(value="Milog log storage")
public class MilogLogStoreDO
extends BaseCommon {
    @Id
    @Comment(value="Primary key Id")
    @ColDefine(customType="bigint")
    private Long id;
    @Column(value="space_id")
    @ColDefine(customType="bigint")
    @Comment(value="spaceId")
    private Long spaceId;
    @Column(value="mq_resource_id")
    @ColDefine(customType="bigint")
    @Comment(value="The primary key ID of the mq resource")
    private Long mqResourceId;
    @Column(value="logstoreName")
    @ColDefine(type=ColType.VARCHAR, width=256)
    @Comment(value="Log storage name")
    private String logstoreName;
    @Column(value="store_period")
    @ColDefine(type=ColType.INT)
    @Comment(value="Storage period: 1-3-5-7")
    private Integer storePeriod;
    @Column(value="shard_cnt")
    @ColDefine(type=ColType.INT)
    @Comment(value="Number of storage shards")
    private Integer shardCnt;
    @Column(value="key_list")
    @ColDefine(type=ColType.VARCHAR, width=1024)
    @Comment(value="A list of keys, multiple separated by commas")
    private String keyList;
    @Column(value="column_type_list")
    @ColDefine(type=ColType.VARCHAR, width=128)
    @Comment(value="Field types, multiple separated by commas")
    private String columnTypeList;
    @Column(value="log_type")
    @ColDefine(type=ColType.INT)
    @Comment(value="1:app,2:ngx..")
    private Integer logType;
    @Column(value="is_matrix_app")
    @ColDefine(type=ColType.BOOLEAN)
    @Default(value="false")
    private Boolean usePlatformResource;
    @Column(value="es_index")
    @ColDefine(type=ColType.VARCHAR, width=256)
    @Comment(value="es index:milog_logstoreName")
    private String esIndex;
    @Column(value="es_cluster_id")
    @ColDefine(customType="bigint")
    @Comment(value="logstore corresponds to the ES cluster ID")
    private Long esClusterId;
    @Column(value="machine_room")
    @ColDefine(type=ColType.VARCHAR, width=50)
    @Comment(value="Computer room information")
    private String machineRoom;

    public MilogLogStoreDO() {
    }

    public MilogLogStoreDO(Long spaceId, String logstoreName, Integer storePeriod, Integer shardCnt, String keyList, Integer logType, Boolean usePlatformResource) {
        this.logstoreName = logstoreName;
        this.spaceId = spaceId;
        this.storePeriod = storePeriod;
        this.shardCnt = shardCnt;
        this.keyList = keyList;
        this.logType = logType;
        this.usePlatformResource = usePlatformResource;
    }

    public boolean isPlatformResourceStore() {
        return this.usePlatformResource == null ? false : this.usePlatformResource;
    }

    public Long getId() {
        return this.id;
    }

    public Long getSpaceId() {
        return this.spaceId;
    }

    public Long getMqResourceId() {
        return this.mqResourceId;
    }

    public String getLogstoreName() {
        return this.logstoreName;
    }

    public Integer getStorePeriod() {
        return this.storePeriod;
    }

    public Integer getShardCnt() {
        return this.shardCnt;
    }

    public String getKeyList() {
        return this.keyList;
    }

    public String getColumnTypeList() {
        return this.columnTypeList;
    }

    public Integer getLogType() {
        return this.logType;
    }

    public Boolean getUsePlatformResource() {
        return this.usePlatformResource;
    }

    public String getEsIndex() {
        return this.esIndex;
    }

    public Long getEsClusterId() {
        return this.esClusterId;
    }

    public String getMachineRoom() {
        return this.machineRoom;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSpaceId(Long spaceId) {
        this.spaceId = spaceId;
    }

    public void setMqResourceId(Long mqResourceId) {
        this.mqResourceId = mqResourceId;
    }

    public void setLogstoreName(String logstoreName) {
        this.logstoreName = logstoreName;
    }

    public void setStorePeriod(Integer storePeriod) {
        this.storePeriod = storePeriod;
    }

    public void setShardCnt(Integer shardCnt) {
        this.shardCnt = shardCnt;
    }

    public void setKeyList(String keyList) {
        this.keyList = keyList;
    }

    public void setColumnTypeList(String columnTypeList) {
        this.columnTypeList = columnTypeList;
    }

    public void setLogType(Integer logType) {
        this.logType = logType;
    }

    public void setUsePlatformResource(Boolean usePlatformResource) {
        this.usePlatformResource = usePlatformResource;
    }

    public void setEsIndex(String esIndex) {
        this.esIndex = esIndex;
    }

    public void setEsClusterId(Long esClusterId) {
        this.esClusterId = esClusterId;
    }

    public void setMachineRoom(String machineRoom) {
        this.machineRoom = machineRoom;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MilogLogStoreDO)) {
            return false;
        }
        MilogLogStoreDO other = (MilogLogStoreDO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$spaceId = this.getSpaceId();
        Long other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !((Object)this$spaceId).equals(other$spaceId)) {
            return false;
        }
        Long this$mqResourceId = this.getMqResourceId();
        Long other$mqResourceId = other.getMqResourceId();
        if (this$mqResourceId == null ? other$mqResourceId != null : !((Object)this$mqResourceId).equals(other$mqResourceId)) {
            return false;
        }
        Integer this$storePeriod = this.getStorePeriod();
        Integer other$storePeriod = other.getStorePeriod();
        if (this$storePeriod == null ? other$storePeriod != null : !((Object)this$storePeriod).equals(other$storePeriod)) {
            return false;
        }
        Integer this$shardCnt = this.getShardCnt();
        Integer other$shardCnt = other.getShardCnt();
        if (this$shardCnt == null ? other$shardCnt != null : !((Object)this$shardCnt).equals(other$shardCnt)) {
            return false;
        }
        Integer this$logType = this.getLogType();
        Integer other$logType = other.getLogType();
        if (this$logType == null ? other$logType != null : !((Object)this$logType).equals(other$logType)) {
            return false;
        }
        Boolean this$usePlatformResource = this.getUsePlatformResource();
        Boolean other$usePlatformResource = other.getUsePlatformResource();
        if (this$usePlatformResource == null ? other$usePlatformResource != null : !((Object)this$usePlatformResource).equals(other$usePlatformResource)) {
            return false;
        }
        Long this$esClusterId = this.getEsClusterId();
        Long other$esClusterId = other.getEsClusterId();
        if (this$esClusterId == null ? other$esClusterId != null : !((Object)this$esClusterId).equals(other$esClusterId)) {
            return false;
        }
        String this$logstoreName = this.getLogstoreName();
        String other$logstoreName = other.getLogstoreName();
        if (this$logstoreName == null ? other$logstoreName != null : !this$logstoreName.equals(other$logstoreName)) {
            return false;
        }
        String this$keyList = this.getKeyList();
        String other$keyList = other.getKeyList();
        if (this$keyList == null ? other$keyList != null : !this$keyList.equals(other$keyList)) {
            return false;
        }
        String this$columnTypeList = this.getColumnTypeList();
        String other$columnTypeList = other.getColumnTypeList();
        if (this$columnTypeList == null ? other$columnTypeList != null : !this$columnTypeList.equals(other$columnTypeList)) {
            return false;
        }
        String this$esIndex = this.getEsIndex();
        String other$esIndex = other.getEsIndex();
        if (this$esIndex == null ? other$esIndex != null : !this$esIndex.equals(other$esIndex)) {
            return false;
        }
        String this$machineRoom = this.getMachineRoom();
        String other$machineRoom = other.getMachineRoom();
        return !(this$machineRoom == null ? other$machineRoom != null : !this$machineRoom.equals(other$machineRoom));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MilogLogStoreDO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : ((Object)$spaceId).hashCode());
        Long $mqResourceId = this.getMqResourceId();
        result = result * 59 + ($mqResourceId == null ? 43 : ((Object)$mqResourceId).hashCode());
        Integer $storePeriod = this.getStorePeriod();
        result = result * 59 + ($storePeriod == null ? 43 : ((Object)$storePeriod).hashCode());
        Integer $shardCnt = this.getShardCnt();
        result = result * 59 + ($shardCnt == null ? 43 : ((Object)$shardCnt).hashCode());
        Integer $logType = this.getLogType();
        result = result * 59 + ($logType == null ? 43 : ((Object)$logType).hashCode());
        Boolean $usePlatformResource = this.getUsePlatformResource();
        result = result * 59 + ($usePlatformResource == null ? 43 : ((Object)$usePlatformResource).hashCode());
        Long $esClusterId = this.getEsClusterId();
        result = result * 59 + ($esClusterId == null ? 43 : ((Object)$esClusterId).hashCode());
        String $logstoreName = this.getLogstoreName();
        result = result * 59 + ($logstoreName == null ? 43 : $logstoreName.hashCode());
        String $keyList = this.getKeyList();
        result = result * 59 + ($keyList == null ? 43 : $keyList.hashCode());
        String $columnTypeList = this.getColumnTypeList();
        result = result * 59 + ($columnTypeList == null ? 43 : $columnTypeList.hashCode());
        String $esIndex = this.getEsIndex();
        result = result * 59 + ($esIndex == null ? 43 : $esIndex.hashCode());
        String $machineRoom = this.getMachineRoom();
        result = result * 59 + ($machineRoom == null ? 43 : $machineRoom.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MilogLogStoreDO(id=" + this.getId() + ", spaceId=" + this.getSpaceId() + ", mqResourceId=" + this.getMqResourceId() + ", logstoreName=" + this.getLogstoreName() + ", storePeriod=" + this.getStorePeriod() + ", shardCnt=" + this.getShardCnt() + ", keyList=" + this.getKeyList() + ", columnTypeList=" + this.getColumnTypeList() + ", logType=" + this.getLogType() + ", usePlatformResource=" + this.getUsePlatformResource() + ", esIndex=" + this.getEsIndex() + ", esClusterId=" + this.getEsClusterId() + ", machineRoom=" + this.getMachineRoom() + ")";
    }
}

