/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.dao;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.MachineTypeEnum;
import org.apache.ozhera.log.api.enums.ProjectTypeEnum;
import org.apache.ozhera.log.api.model.meta.FilterDefine;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.FieldFilter;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Record;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MilogLogTailDao {
    private static final Logger log = LoggerFactory.getLogger(MilogLogTailDao.class);
    @Resource
    private NutDao dao;

    public MilogLogTailDo add(MilogLogTailDo mt) {
        return (MilogLogTailDo)this.dao.insert((Object)mt);
    }

    public boolean update(MilogLogTailDo mt) {
        return 1 == this.dao.update((Object)mt);
    }

    public boolean updateMilogLogtail(Long id, Integer parseType, String parseScript, String logPath, String valueList, Long appId, Long envId, String envName, String tail, List<String> ips, List<FilterDefine> confs, Long milogAppId, String appName, String logSplitExpress, Integer deployWay, String deploySpace, String firstLineReg) {
        Chain chain = Chain.make((String)"parse_type", (Object)parseType).add("parse_script", (Object)parseScript).add("log_path", (Object)logPath).add("value_list", (Object)valueList).add("env_id", (Object)envId).add("env_name", (Object)envName).add("tail", (Object)tail).add("ips", ips).add("filter", confs).add("milog_app_id", (Object)milogAppId).add("app_name", (Object)appName).add("deploy_way", (Object)deployWay).add("deploy_space", (Object)deploySpace).add("first_line_reg", (Object)firstLineReg);
        if (null != appId) {
            chain.add("app_id", (Object)appId);
        }
        chain.add("log_split_express", (Object)logSplitExpress);
        chain.add("utime", (Object)Instant.now().toEpochMilli());
        chain.add("updater", (Object)MoneUserContext.getCurrentUser().getUser());
        int ret = this.dao.update(MilogLogTailDo.class, chain, (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
        return ret == 1;
    }

    public boolean deleteMilogLogtail(Long id) {
        int ret = this.dao.clear(MilogLogTailDo.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
        return ret == 1;
    }

    public List<MilogLogTailDo> queryTailByAppName(String appName) {
        Cnd cnd = Cnd.NEW();
        if (!StringUtils.isNotEmpty((CharSequence)appName)) {
            cnd = cnd.and("app_name", "=", (Object)appName);
        }
        return this.dao.query(MilogLogTailDo.class, (Condition)cnd);
    }

    public List<MilogLogTailDo> getMilogLogtail(List<Long> ids) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"id", (String)"in", ids));
    }

    public List<MilogLogTailDo> getMilogLogtailByStoreId(Long storeId) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"store_id", (String)"=", (Object)storeId));
    }

    public List<MilogLogTailDo> getMilogLogtailByStoreIds(List<Long> ids) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"store_id", (String)"in", ids).orderBy("ctime", "desc"));
    }

    public List<MilogLogTailDo> getMilogLogtailByPage(Long storeId, int page, int pagesize) {
        Cnd cnd = Cnd.where((String)"store_id", (String)"=", (Object)storeId);
        return this.dao.query(MilogLogTailDo.class, (Condition)cnd.orderBy("ctime", "desc"), new Pager(page, pagesize));
    }

    public int getTailCount(Long storeId) {
        Cnd cnd = Cnd.where((String)"store_id", (String)"=", (Object)storeId);
        return this.dao.count(MilogLogTailDo.class, (Condition)cnd);
    }

    public List<MilogLogTailDo> getMilogLogtailByPage(String appName, int page, int pagesize) {
        Cnd cnd = Cnd.NEW();
        if (!StringUtils.isEmpty((CharSequence)appName)) {
            cnd = cnd.and("app_name", "like", (Object)("%" + appName + "%"));
        }
        List ret = this.dao.query(MilogLogTailDo.class, (Condition)cnd.orderBy("ctime", "desc"), new Pager(page, pagesize));
        return ret;
    }

    public Map<Long, List<MilogLogTailDo>> getMilogLogtailByAppId(List<Long> appIds) {
        HashMap<Long, List<MilogLogTailDo>> ret = new HashMap<Long, List<MilogLogTailDo>>();
        for (Long appId : appIds) {
            List logtails = this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"app_id", (String)"=", (Object)appId));
            if (logtails == null || logtails.size() <= 0) continue;
            ret.put(appId, logtails);
        }
        return ret;
    }

    public List<MilogLogTailDo> queryByAppIds(Long[] appIds) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"app_id", (String)"in", (Object)appIds));
    }

    public List<MilogLogTailDo> queryByAppIdAgentIp(Long milogAppId, String agentIp) {
        Sql sql = Sqls.queryEntity((String)"SELECT * FROM milog_logstail WHERE milog_app_id = @milogAppId AND JSON_CONTAINS( ips, JSON_ARRAY( @ip))");
        sql.params().set("milogAppId", (Object)milogAppId);
        sql.params().set("ip", (Object)agentIp);
        sql.setEntity(this.dao.getEntity(MilogLogTailDo.class));
        this.dao.execute(sql);
        return sql.getList(MilogLogTailDo.class);
    }

    public List<MilogLogTailDo> queryByAppAndEnv(Long appId, Long envId) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"app_id", (String)"=", (Object)appId).and("env_id", "=", (Object)envId));
    }

    public List<MilogLogTailDo> queryByMilogAppAndEnv(Long milogAppId, Long envId) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"milog_app_id", (String)"=", (Object)milogAppId).and("env_id", "=", (Object)envId));
    }

    public List<MilogLogTailDo> queryByMilogAppAndEnvId(Long milogAppId, Long envId) {
        Cnd cnd = Cnd.where((String)"milog_app_id", (String)"=", (Object)milogAppId);
        if (null != envId) {
            cnd.and("env_id", "=", (Object)envId);
        }
        return this.dao.query(MilogLogTailDo.class, (Condition)cnd);
    }

    public List<MilogLogTailDo> queryByMilogAppAndEnvK8s(Long milogAppId, Long envId, Integer deploy_way) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"milog_app_id", (String)"=", (Object)milogAppId).and("env_id", "=", (Object)envId).and("deploy_way", "=", (Object)deploy_way));
    }

    public MilogLogTailDo queryById(Long id) {
        if (null == id) {
            return null;
        }
        return (MilogLogTailDo)this.dao.fetch(MilogLogTailDo.class, id.longValue());
    }

    public List<Long> queryAllIds() {
        String idKey = "id";
        List records = this.dao.query("milog_logstail", null, null, idKey);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            return records.stream().map(record -> record.getLong(idKey)).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public List<MilogLogTailDo> getLogTailByMilogAppId(Long milogAppId) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"milog_app_id", (String)"=", (Object)milogAppId));
    }

    public MilogLogTailDo getTailByName(String tailName, Integer appType) {
        return (MilogLogTailDo)this.dao.fetch(MilogLogTailDo.class, (Condition)Cnd.where((String)"tail", (String)"=", (Object)tailName).and("app_type", "=", (Object)appType));
    }

    public List<MilogLogTailDo> queryByAppType(Integer appType) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"app_type", (String)"=", (Object)appType));
    }

    public List<MilogLogTailDo> getMilogLogtailByIdsAndName(List<Long> ids, String tail, Integer appType) {
        Cnd cnd = Cnd.where((String)"store_id", (String)"in", ids);
        if (!StringUtils.isEmpty((CharSequence)tail)) {
            cnd.and("tail", "like", (Object)("%" + tail + "%"));
        }
        if (null != appType) {
            cnd.and("app_type", "=", (Object)appType);
        }
        return this.dao.query(MilogLogTailDo.class, (Condition)cnd);
    }

    public List<MilogLogTailDo> queryByIp(String ip) {
        Sql sql = Sqls.queryEntity((String)"SELECT * FROM milog_logstail WHERE JSON_CONTAINS(`ips`, JSON_ARRAY( @ip )) and collection_ready = 1");
        sql.params().set("ip", (Object)ip);
        sql.setEntity(this.dao.getEntity(MilogLogTailDo.class));
        this.dao.execute(sql);
        return sql.getList(MilogLogTailDo.class);
    }

    public int appCount() {
        Sql sql = Sqls.queryRecord((String)"SELECT count(DISTINCT app_id) as access from milog_logstail");
        LinkedList records = (LinkedList)this.dao.execute(sql).getResult();
        int access = ((Record)records.get(0)).getInt("access");
        return access;
    }

    public List<MilogLogTailDo> getAll(String source) {
        Sql sql = Sqls.queryEntity((String)"SELECT ml.* FROM milog_logstail ml LEFT JOIN milog_app_topic_rel mt ON ml.app_id = mt.app_id WHERE mt.source = @source");
        sql.setEntity(this.dao.getEntity(MilogLogTailDo.class));
        sql.params().set("source", (Object)source);
        this.dao.execute(sql);
        return sql.getList(MilogLogTailDo.class);
    }

    public String queryTailNameByAppIdAndName(String appId, String ip) {
        Sql sql = Sqls.queryString((String)("SELECT tail FROM milog_logstail WHERE app_id=@appId and JSON_CONTAINS(ips, '[\"" + ip + "\"]');"));
        sql.params().set("appId", (Object)appId);
        this.dao.execute(sql);
        return sql.getString();
    }

    public List<MilogLogTailDo> queryAppIdByStoreId(Long storeId) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"store_id", (String)"=", (Object)storeId));
    }

    public List<MilogLogTailDo> getLogTailByLimit(int offset, int rows) {
        String sqlString = String.format("select * from milog_logstail limit %d,%d", offset, rows);
        Sql sql = Sqls.queryEntity((String)sqlString);
        sql.setEntity(this.dao.getEntity(MilogLogTailDo.class));
        this.dao.execute(sql);
        return sql.getList(MilogLogTailDo.class);
    }

    public List<MilogLogTailDo> queryStoreIdByRegionNameEN(String nameEn) {
        Sql sql = Sqls.queryEntity((String)"SELECT * FROM `milog_logstail` where JSON_CONTAINS(motor_rooms, JSON_OBJECT(\"nameEn\", @nameEn))");
        sql.params().set("nameEn", (Object)nameEn);
        sql.setEntity(this.dao.getEntity(MilogLogTailDo.class));
        this.dao.execute(sql);
        return sql.getList(MilogLogTailDo.class);
    }

    public List<MilogLogTailDo> queryTailNameExists(String tailName, String machineRoom, Long spaceId) {
        Sql sql = Sqls.queryEntity((String)"SELECT la.* FROM milog_logstail la LEFT JOIN milog_logstore lt ON la.store_id = lt.id WHERE la.tail = @tailName AND lt.machine_room = @machineRoom and la.space_id = @spaceId");
        sql.params().set("tailName", (Object)tailName);
        sql.params().set("machineRoom", (Object)machineRoom);
        sql.params().set("spaceId", (Object)spaceId);
        sql.setEntity(this.dao.getEntity(MilogLogTailDo.class));
        this.dao.execute(sql);
        return sql.getList(MilogLogTailDo.class);
    }

    public List<MilogLogTailDo> queryTailsByStoreId(Long storeId) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"store_id", (String)"=", (Object)storeId));
    }

    public MilogLogTailDo queryTailByMilogAppIdAndIps(Long milogAppId, List<String> ips) {
        List MilogLogTailDoList = this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"milog_app_id", (String)"=", (Object)milogAppId));
        if (CollectionUtils.isNotEmpty((Collection)MilogLogTailDoList)) {
            return MilogLogTailDoList.stream().filter(MilogLogTailDo2 -> CollectionUtils.isEqualCollection(MilogLogTailDo2.getIps(), (Collection)ips)).findFirst().get();
        }
        return null;
    }

    public Long queryMinTailCountStoreId(Long spaceId, List<Long> storeIdList) {
        Sql sql = Sqls.create((String)("SELECT t.mKey FROM( SELECT count( id) AS mValue, store_id AS mKey FROM milog_logstail WHERE space_id = @spaceId AND store_id IN (" + storeIdList.stream().map(String::valueOf).collect(Collectors.joining(",")) + ") GROUP BY store_id ) t ORDER BY t.mValue LIMIT 1"));
        sql.params().set("spaceId", (Object)spaceId);
        sql.setCallback((SqlCallback & Serializable)(conn, rs, sql1) -> {
            Long minCountStoreId = null;
            while (rs.next()) {
                minCountStoreId = rs.getLong(1);
            }
            return minCountStoreId;
        });
        Long object = (Long)this.dao.execute(sql).getObject(Long.class);
        return object;
    }

    public MilogLogTailDo queryServerlessTailByFuncId(Long spaceId, Long storeId, Long milogAppId, Long funcId) {
        List logTailDos = this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"space_id", (String)"=", (Object)spaceId).and("milog_app_id", "=", (Object)milogAppId).and("env_id", "=", (Object)funcId));
        if (CollectionUtils.isNotEmpty((Collection)logTailDos)) {
            return (MilogLogTailDo)logTailDos.get(logTailDos.size() - 1);
        }
        return null;
    }

    public List<MilogLogTailDo> queryTailsByAppAndStores(Long appId, List<Long> storeIds) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"app_id", (String)"=", (Object)appId).and("app_type", "=", (Object)ProjectTypeEnum.MIONE_TYPE).and("store_id", "in", storeIds));
    }

    public List<MilogLogTailDo> queryTailsByStores(List<Long> storeIds) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"store_id", (String)"in", storeIds));
    }

    public List<Integer> queryAllAppId() {
        Sql sql = Sqls.create((String)"SELECT DISTINCT milog_app_id FROM milog_logstail");
        sql.setCallback((SqlCallback & Serializable)(conn, rs, sql1) -> {
            ArrayList appBaseIds = Lists.newArrayList();
            while (rs.next()) {
                appBaseIds.add(rs.getInt(1));
            }
            return appBaseIds;
        });
        return this.dao.execute(sql).getList(Integer.class);
    }

    public List<MilogLogTailDo> queryTailWithAppIdNull() {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"app_id", (String)"is", null));
    }

    public List<MilogLogTailDo> queryByAppId(Long appId) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"app_id", (String)"=", (Object)appId));
    }

    public List<MilogLogTailDo> queryByAppId(Long appId, Long milogAppId) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"app_id", (String)"=", (Object)appId).and("milog_app_id", "=", (Object)milogAppId));
    }

    public List<MilogLogTailDo> queryByIds(List<Long> tailIds) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"id", (String)"in", tailIds));
    }

    public void updateIps(MilogLogTailDo milogLogtailDo) {
        this.dao.update((Object)milogLogtailDo, FieldFilter.create(MilogLogTailDo.class, (String)"ips|utime|updater"));
    }

    public List<MilogLogTailDo> queryAppTypeTailByAppId(Long serviceId, Integer typeCode) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"app_id", (String)"=", (Object)serviceId).and("app_type", "=", (Object)typeCode).and("machine_type", "=", (Object)MachineTypeEnum.PHYSICAL_MACHINE.getType()));
    }

    public List<MilogLogTailDo> queryByNames(Long storeId, List<String> nameList) {
        Cnd cnd = Cnd.where((String)"store_id", (String)"=", (Object)storeId).and("tail", "in", nameList);
        return this.dao.query(MilogLogTailDo.class, (Condition)cnd);
    }

    public List<MilogLogTailDo> queryByCondition(Long spaceId, Long storeId, String tailName, Long heraAppId, Long envId, String logPath) {
        return this.dao.query(MilogLogTailDo.class, (Condition)Cnd.where((String)"space_id", (String)"=", (Object)spaceId).and("store_id", "=", (Object)storeId).and("tail", "=", (Object)tailName).and("milog_app_id", "=", (Object)heraAppId).and("env_id", "=", (Object)envId).and("log_path", "=", (Object)logPath));
    }
}

