/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.controller;

import com.xiaomi.youpin.docean.anno.Controller;
import com.xiaomi.youpin.docean.anno.RequestMapping;
import com.xiaomi.youpin.docean.anno.RequestParam;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ozhera.log.api.model.dto.TraceLogDTO;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.model.dto.LogDTO;
import org.apache.ozhera.log.manager.model.dto.LogtailCollectTopDTO;
import org.apache.ozhera.log.manager.model.dto.LogtailCollectTrendDTO;
import org.apache.ozhera.log.manager.model.dto.SearchSaveDTO;
import org.apache.ozhera.log.manager.model.dto.SpaceCollectTopDTO;
import org.apache.ozhera.log.manager.model.dto.SpaceCollectTrendDTO;
import org.apache.ozhera.log.manager.model.dto.SpaceTreeFavouriteDTO;
import org.apache.ozhera.log.manager.model.vo.KeywordPageParam;
import org.apache.ozhera.log.manager.model.vo.LogContextQuery;
import org.apache.ozhera.log.manager.model.vo.LogQuery;
import org.apache.ozhera.log.manager.model.vo.RegionTraceLogQuery;
import org.apache.ozhera.log.manager.model.vo.SearchSaveInsertCmd;
import org.apache.ozhera.log.manager.model.vo.SearchSaveUpdateCmd;
import org.apache.ozhera.log.manager.model.vo.TraceAppLogUrlQuery;
import org.apache.ozhera.log.manager.model.vo.UpdateIndexTemplateCommand;
import org.apache.ozhera.log.manager.service.impl.EsDataServiceImpl;
import org.apache.ozhera.log.manager.service.impl.EsIndexTemplateServiceImpl;
import org.apache.ozhera.log.manager.service.impl.LogCountServiceImpl;
import org.apache.ozhera.log.manager.service.impl.MilogLogSearchSaveServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
public class EsDataController {
    private static final Logger log = LoggerFactory.getLogger(EsDataController.class);
    @Resource
    private EsDataServiceImpl esDataService;
    @Resource
    private EsIndexTemplateServiceImpl esIndexTemplateService;
    @Resource
    private LogCountServiceImpl logCountService;
    @Resource
    private MilogLogSearchSaveServiceImpl searchSaveService;

    @RequestMapping(path="/es/updateIndexTemplate", method="POST")
    public Boolean updateIndexTemplate(@RequestParam(value="updateIndexTemplateCommand") UpdateIndexTemplateCommand updateIndexTemplateCommand) throws IOException {
        return this.esIndexTemplateService.updateIndexTemplate(updateIndexTemplateCommand);
    }

    @RequestMapping(path="/es/createIndex", method="get")
    public Boolean createIndex(@RequestParam(value="templateName") String templateName) throws IOException {
        return this.esIndexTemplateService.createIndex(templateName);
    }

    @RequestMapping(path="/log/export", method="get")
    public void logExport(@RequestParam(value="logstore") String logstore, @RequestParam(value="storeId") Long storeId, @RequestParam(value="tail") String tail, @RequestParam(value="startTime") Long startTime, @RequestParam(value="endTime") Long endTime, @RequestParam(value="fullTextSearch") String fullTextSearch) throws Exception {
        LogQuery logQuery = new LogQuery(logstore, storeId, tail, startTime, endTime, fullTextSearch, "timestamp");
        this.esDataService.logExport(logQuery);
    }

    @RequestMapping(path="/log/query")
    public Result<LogDTO> logQuery(LogQuery logQuery) {
        return this.esDataService.logQuery(logQuery);
    }

    @RequestMapping(path="/log/context")
    public Result<LogDTO> logContext(LogContextQuery logContextQuery) throws Exception {
        return this.esDataService.getDocContext(logContextQuery);
    }

    @RequestMapping(path="/log/queryRegionTraceLog")
    public Result<TraceLogDTO> queryRegionTraceLog(RegionTraceLogQuery regionTraceLogQuery) throws IOException {
        return this.esDataService.queryRegionTraceLog(regionTraceLogQuery);
    }

    @RequestMapping(path="/log/statistics/collectTop", method="get")
    public Result<List<LogtailCollectTopDTO>> collectTop() {
        return this.logCountService.collectTop();
    }

    @RequestMapping(path="/log/statistics/spaceCollectTop", method="get")
    public Result<List<SpaceCollectTopDTO>> spaceCollectTop() {
        return this.logCountService.collectSpaceTop();
    }

    @RequestMapping(path="/log/statistics/collectTrend", method="get")
    public Result<List<LogtailCollectTrendDTO>> collectTrend(@RequestParam(value="tailId") Long tailId) throws IOException {
        return this.logCountService.collectTrend(tailId);
    }

    @RequestMapping(path="/log/statistics/spaceCollectTrend", method="get")
    public Result<List<SpaceCollectTrendDTO>> spaceCollectTrend(@RequestParam(value="spaceId") Long spaceId) {
        return this.logCountService.spaceCollectTrend(spaceId);
    }

    @RequestMapping(path="/log/statistics/collectTrendRefresh", method="get")
    public void collectTrendRefresh() {
        this.logCountService.collectTrendRefresh();
    }

    @RequestMapping(path="/log/statistics/spaceCollectTrendRefresh", method="get")
    public void spaceCollectTrendRefresh() {
        this.logCountService.collectSpaceTrend();
    }

    @RequestMapping(path="/log/statistics/collectLogCount", method="get")
    public void collectLogCount(@RequestParam(value="thisDay") String thisDay) throws IOException {
        try {
            this.logCountService.collectLogCount(thisDay);
        }
        catch (Exception e) {
            log.error("Log statistics failed,error:[{}]", (Object)e.getMessage());
        }
    }

    @RequestMapping(path="/log/statistics/collectTopCount", method="get")
    public void collectTopCount() throws IOException {
        this.logCountService.collectTopCount();
    }

    @RequestMapping(path="/log/statistics/collectSpaceTopRefresh", method="get")
    public void collectSpaceTopRefresh() {
        this.logCountService.collectSpaceTopCount();
    }

    @RequestMapping(path="/log/statistics/collectLogDelete", method="get")
    public void collectLogDelete(@RequestParam(value="thisDay") String thisDay) throws IOException {
        this.logCountService.collectLogDelete(thisDay);
    }

    @RequestMapping(path="/log/statistics/showLogCountCache", method="get")
    public void showLogCountCache() throws IOException {
        this.logCountService.showLogCountCache();
    }

    @RequestMapping(path="/log/save/list", method="get")
    public Result<List<SearchSaveDTO>> searchSavelList(@RequestParam(value="storeId") Long storeId, @RequestParam(value="sort") Integer sort) {
        return this.searchSaveService.list(storeId, sort);
    }

    @RequestMapping(path="/log/save/detail", method="get")
    public SearchSaveDTO saveDetail(@RequestParam(value="id") Long id) {
        return this.searchSaveService.getById(id);
    }

    @RequestMapping(path="/log/save/favourite")
    public Result<Integer> saveSearchSave(SearchSaveInsertCmd cmd) {
        return this.searchSaveService.save(cmd);
    }

    @RequestMapping(path="/log/save/defavourite", method="get")
    public Result<Integer> defavourite(@RequestParam(value="sort") Integer sort, @RequestParam(value="id") Long id) {
        return this.searchSaveService.deFavourite(sort, id);
    }

    @RequestMapping(path="/log/save/update")
    public Result<Integer> saveSearchUpdate(SearchSaveUpdateCmd cmd) {
        return this.searchSaveService.update(cmd);
    }

    @RequestMapping(path="/log/save/swap", method="get")
    public Result<Boolean> swap(@RequestParam(value="idFrom") Long idFrom, @RequestParam(value="idTo") Long idTo) {
        return this.searchSaveService.swapOrder(idFrom, idTo);
    }

    @RequestMapping(path="/log/save/delete", method="get")
    public Result<Integer> saveDelete(@RequestParam(value="id") Long id) {
        return this.searchSaveService.removeById(id);
    }

    @RequestMapping(path="/log/trace/url")
    public Result<String> getTraceAppLogUrl(TraceAppLogUrlQuery query) {
        return this.esDataService.getTraceAppLogUrl(query);
    }

    @RequestMapping(path="/log/save/storeTree")
    public Result<List<SpaceTreeFavouriteDTO>> storeTree(KeywordPageParam keywordPageParam) {
        return this.searchSaveService.storeTree(keywordPageParam);
    }

    @RequestMapping(path="/log/save/initOrder", method="get")
    public Result<Integer> initOrder(@RequestParam(value="key") String key) {
        return this.searchSaveService.initOrder(key);
    }
}

