/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExecutorUtil {
    private static final Logger log = LoggerFactory.getLogger(ExecutorUtil.class);
    public static BlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(30000);
    public static BlockingQueue<Runnable> consumerDelayMsgQueue = new ArrayBlockingQueue<Runnable>(30000);
    public static BlockingQueue<Runnable> rocksThreadQueue = new ArrayBlockingQueue<Runnable>(2);
    public static final int ROCKSDB_DEAL_MESSAGE_CORE = 20;
    private static final ThreadPoolExecutor errorESthreadPoolExecutor = new ThreadPoolExecutor(2, 5, 0L, TimeUnit.MILLISECONDS, queue);
    private static final ThreadPoolExecutor consumerDelayMsgthreadPoolExecutor = new ThreadPoolExecutor(20, 20, 0L, TimeUnit.MILLISECONDS, consumerDelayMsgQueue);
    private static final ThreadPoolExecutor rocksDBThreadPool = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, rocksThreadQueue);

    public static void submit(Runnable runnable) {
        try {
            errorESthreadPoolExecutor.submit(runnable);
        }
        catch (Exception e) {
            log.error("Failed to submit an error es task:", (Throwable)e);
        }
    }

    public static void submitDelayMessage(Runnable runnable) {
        try {
            consumerDelayMsgthreadPoolExecutor.submit(runnable);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5ef6\u8fdf\u6d88\u606f\u4efb\u52a1\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public static void submitRocksDBRead(Runnable runnable) {
        try {
            rocksDBThreadPool.submit(runnable);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4rocksdb\u8bfb\u53d6\u4efb\u52a1\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

