/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.agent.channel.memory.ChannelMemory;
import org.apache.ozhera.log.common.Constant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelUtil {
    private static final Logger log = LoggerFactory.getLogger(ChannelUtil.class);

    private ChannelUtil() {
    }

    public static List<String> buildLogExpressList(String logPattern) {
        ArrayList pathList = Lists.newArrayList();
        for (String filePath : ((String)logPattern).split(",")) {
            String filePrefix = StringUtils.substringBeforeLast((String)filePath, (String)"/");
            String multipleFileNames = StringUtils.substringAfterLast((String)filePath, (String)"/");
            logPattern = filePath.contains("*") && !filePath.contains(".*") ? ((String)logPattern).replaceAll("\\*", ".*") : Arrays.stream(multipleFileNames.split("\\|")).map(s -> filePrefix + "/" + s + ".*").collect(Collectors.joining("|"));
            if (!((String)logPattern).endsWith(".*")) {
                logPattern = (String)logPattern + ".*";
            }
            pathList.add(logPattern);
        }
        return pathList;
    }

    public static String buildSingleTimeExpress(String filePath) {
        String filePrefix = StringUtils.substringBeforeLast((String)filePath, (String)"/");
        String multipleFileName = StringUtils.substringAfterLast((String)filePath, (String)"/");
        if (!multipleFileName.contains(".*")) {
            multipleFileName = multipleFileName.replaceAll("\\*", ".*");
        }
        if (multipleFileName.startsWith("*")) {
            multipleFileName = multipleFileName.replaceFirst("\\*", ".*");
        }
        return String.format("%s%s%s", filePrefix, "/", multipleFileName);
    }

    public static ChannelMemory.UnixFileNode buildUnixFileNode(String filePath) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(Paths.get(filePath, new String[0]), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (null != fileAttributes.fileKey()) {
                ChannelMemory.UnixFileNode unixFileNode = (ChannelMemory.UnixFileNode)Constant.GSON.fromJson(Constant.GSON.toJson(fileAttributes.fileKey()), ChannelMemory.UnixFileNode.class);
                log.debug("origin file path:{},fileNode unixFileNode:{}", (Object)filePath, (Object)Constant.GSON.toJson((Object)unixFileNode));
                return unixFileNode;
            }
        }
        catch (Exception e) {
            log.info("buildUnixFileNode error,filePath:{}", (Object)filePath, (Object)e);
        }
        return new ChannelMemory.UnixFileNode();
    }

    public static long countFilesRecursive(File directory) {
        long count = 0L;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    count += ChannelUtil.countFilesRecursive(file);
                    continue;
                }
                ++count;
            }
        }
        return count;
    }
}

