/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel.listener;

import cn.hutool.core.io.FileUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.agent.channel.ChannelService;
import org.apache.ozhera.log.agent.channel.file.FileMonitor;
import org.apache.ozhera.log.agent.channel.file.MonitorFile;
import org.apache.ozhera.log.agent.channel.listener.FileMonitorListener;
import org.apache.ozhera.log.agent.common.ChannelUtil;
import org.apache.ozhera.log.agent.common.ExecutorUtil;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.common.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileMonitorListener
implements FileMonitorListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultFileMonitorListener.class);
    private static Gson gson = new Gson();
    private String defaultMonitorPath = "/home/work/log/";
    List<String> pathList = new CopyOnWriteArrayList<String>();
    private List<FileAlterationMonitor> monitorList = new CopyOnWriteArrayList<FileAlterationMonitor>();
    private Map<String, Future<?>> scheduledFutureMap = new ConcurrentHashMap();
    Map<List<MonitorFile>, ChannelService> pathChannelServiceMap = new ConcurrentHashMap<List<MonitorFile>, ChannelService>();
    private final List<String> specialFileNameSuffixList = Lists.newArrayList((Object[])new String[]{"wf"});
    private static final int DEFAULT_FILE_SIZE = 100000;

    public DefaultFileMonitorListener() {
        long size = this.getDefaultFileSize();
        log.info("defaultMonitorPath:{} file size:{}", (Object)this.defaultMonitorPath, (Object)size);
        if (size < 100000L) {
            this.startFileMonitor(this.defaultMonitorPath);
            this.pathList.add(this.defaultMonitorPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getDefaultFileSize() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Long> fileSizeFuture = executor.submit(() -> ChannelUtil.countFilesRecursive(new File(this.defaultMonitorPath)));
        try {
            long l = fileSizeFuture.get(1L, TimeUnit.SECONDS);
            return l;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.info("getDefaultFileSize error", (Throwable)e);
            fileSizeFuture.cancel(true);
        }
        finally {
            executor.shutdown();
        }
        return 200000L;
    }

    @Override
    public void addChannelService(ChannelService channelService) {
        List<MonitorFile> monitorPathList = channelService.getMonitorPathList();
        if (CollectionUtils.isEmpty(monitorPathList)) {
            return;
        }
        List<String> newMonitorDirectories = this.newMonitorDirectories(monitorPathList);
        for (String watchDirectory : newMonitorDirectories) {
            if (!this.isValidWatch(watchDirectory)) continue;
            this.startFileMonitor(watchDirectory);
            this.pathList.add(watchDirectory);
        }
        this.pathChannelServiceMap.put(monitorPathList, channelService);
    }

    private boolean isValidWatch(String watchDirectory) {
        if (this.pathList.contains(watchDirectory)) {
            return false;
        }
        for (String path : this.pathList) {
            if (!watchDirectory.startsWith(path)) continue;
            return false;
        }
        return true;
    }

    private List<String> newMonitorDirectories(List<MonitorFile> monitorPathList) {
        log.info("start newMonitorDirectories:{}", (Object)gson.toJson(monitorPathList));
        List<Object> newMonitorDirectories = Lists.newArrayList();
        Set expressList = monitorPathList.stream().map(MonitorFile::getMonitorFileExpress).collect(Collectors.toSet());
        HashSet realExpressList = Sets.newHashSet();
        for (String express : expressList) {
            if (express.startsWith("(") && express.endsWith(")") && express.contains("|")) {
                for (String perExpress : StringUtils.substringBetween((String)express, (String)"(", (String)")").split("\\|")) {
                    realExpressList.add(perExpress);
                }
                continue;
            }
            realExpressList.add(express);
        }
        for (String perExpress : realExpressList) {
            if (!this.pathList.stream().noneMatch(perExpress::startsWith)) continue;
            List watchDList = PathUtils.parseWatchDirectory((String)perExpress);
            String monitorDirectory = (String)watchDList.get(0);
            if (monitorDirectory.contains(".*")) {
                monitorDirectory = StringUtils.substringBefore((String)monitorDirectory, (String)".*");
            }
            if (!this.pathList.stream().noneMatch(monitorDirectory::startsWith)) continue;
            newMonitorDirectories.add(monitorDirectory);
        }
        newMonitorDirectories = newMonitorDirectories.stream().distinct().collect(Collectors.toList());
        log.info("end newMonitorDirectories:", (Object)gson.toJson((Object)newMonitorDirectories));
        return newMonitorDirectories;
    }

    @Override
    public void removeChannelService(ChannelService channelService) {
        try {
            this.pathChannelServiceMap.remove(channelService.getMonitorPathList());
            List<MonitorFile> monitorPathList = channelService.getMonitorPathList();
            List<String> newMonitorDirectories = this.newMonitorDirectories(monitorPathList);
            for (String watchDirectory : newMonitorDirectories) {
                this.pathList.remove(watchDirectory);
                if (!this.scheduledFutureMap.containsKey(watchDirectory)) continue;
                this.scheduledFutureMap.get(watchDirectory).cancel(true);
            }
        }
        catch (Exception e) {
            log.error("removeChannelService file listener,monitorPathList:{}", (Object)gson.toJson(channelService.getMonitorPathList()), (Object)e);
        }
    }

    public void startFileMonitor(String monitorFilePath) {
        log.debug("startFileMonitor,monitorFilePath:{}", (Object)monitorFilePath);
        if (this.pathList.stream().anyMatch(monitorFilePath::startsWith)) {
            log.info("current path has started,monitorFilePath:{},pathList:{}", (Object)monitorFilePath, (Object)String.join((CharSequence)",", this.pathList));
            return;
        }
        Future<?> fileMonitorFuture = ExecutorUtil.submit(() -> new FileMonitor().watch(monitorFilePath, this.monitorList, changedFilePath -> {
            try {
                if (FileUtil.isDirectory((String)changedFilePath)) {
                    return;
                }
                log.info("monitor changedFilePath\uff1a{}", changedFilePath);
                List<String> filterSuffixList = this.judgeSpecialFileNameSuffix((String)changedFilePath);
                if (CollectionUtils.isNotEmpty(filterSuffixList)) {
                    this.specialFileSuffixChanged((String)changedFilePath, filterSuffixList);
                    return;
                }
                this.ordinaryFileChanged((String)changedFilePath);
            }
            catch (Exception e) {
                log.error("FileMonitor error,monitorFilePath:{},changedFilePath:{}", new Object[]{monitorFilePath, changedFilePath, e});
            }
        }));
        this.scheduledFutureMap.put(monitorFilePath, fileMonitorFuture);
    }

    private void ordinaryFileChanged(String changedFilePath) {
        for (Map.Entry<List<MonitorFile>, ChannelService> channelServiceEntry : this.pathChannelServiceMap.entrySet()) {
            for (MonitorFile monitorFile : channelServiceEntry.getKey()) {
                if (!monitorFile.getFilePattern().matcher(changedFilePath).matches()) continue;
                String reOpenFilePath = monitorFile.getRealFilePath();
                if (LogTypeEnum.OPENTELEMETRY == monitorFile.getLogTypeEnum() || reOpenFilePath.contains("*")) {
                    reOpenFilePath = String.format("%s%s%s", StringUtils.substringBeforeLast((String)changedFilePath, (String)"/"), "/", StringUtils.substringAfterLast((String)reOpenFilePath, (String)"/"));
                }
                if (monitorFile.isCollectOnce()) {
                    reOpenFilePath = changedFilePath;
                }
                log.info("\u3010change file path reopen\u3011started,changedFilePath:{},realFilePath:{},monitorFileExpress:{}", new Object[]{changedFilePath, reOpenFilePath, monitorFile.getMonitorFileExpress()});
                channelServiceEntry.getValue().reOpen(reOpenFilePath);
                log.info("\u3010end change file path\u3011 end,changedFilePath:{},realFilePath:{},monitorFileExpress:{},InstanceId:{}", new Object[]{changedFilePath, reOpenFilePath, monitorFile.getMonitorFileExpress(), channelServiceEntry.getValue().instanceId()});
            }
        }
    }

    private void specialFileSuffixChanged(String changedFilePath, List<String> filterSuffixList) {
        HashMap<String, ChannelService> serviceMap = new HashMap<String, ChannelService>();
        for (Map.Entry<List<MonitorFile>, ChannelService> entry : this.pathChannelServiceMap.entrySet()) {
            for (MonitorFile monitorFile : entry.getKey()) {
                if (!filterSuffixList.stream().filter(s -> monitorFile.getRealFilePath().contains((CharSequence)s)).findAny().isPresent() || !monitorFile.getFilePattern().matcher(changedFilePath).matches()) continue;
                serviceMap.put(monitorFile.getRealFilePath(), entry.getValue());
            }
        }
        for (Map.Entry<List<MonitorFile>, ChannelService> entry : serviceMap.entrySet()) {
            entry.getValue().reOpen((String)((Object)entry.getKey()));
        }
    }

    private List<String> judgeSpecialFileNameSuffix(String changedFilePath) {
        String changedFileName = StringUtils.substringAfterLast((String)changedFilePath, (String)"/");
        return this.specialFileNameSuffixList.stream().filter(s -> changedFileName.contains((CharSequence)s)).collect(Collectors.toList());
    }
}

