/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel.file;

import cn.hutool.core.util.ReflectUtil;
import com.xiaomi.data.push.rpc.common.RemotingUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.io.monitor.FileEntry;
import org.apache.ozhera.log.agent.channel.file.InodeFileComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileAlterationObserver
extends FileAlterationObserver {
    private static final Logger log = LoggerFactory.getLogger(LogFileAlterationObserver.class);
    private static final FileEntry[] EMPTY_ENTRIES = new FileEntry[0];
    private FileEntry childRootEntry;
    private Comparator<File> childComparator;

    public LogFileAlterationObserver(String directoryName) {
        this(new File(directoryName));
    }

    public LogFileAlterationObserver(String directoryName, FileFilter fileFilter) {
        this(new File(directoryName), fileFilter);
    }

    public LogFileAlterationObserver(String directoryName, FileFilter fileFilter, IOCase caseSensitivity) {
        this(new File(directoryName), fileFilter, caseSensitivity);
    }

    public LogFileAlterationObserver(File directory) {
        this(directory, null);
    }

    public LogFileAlterationObserver(File directory, FileFilter fileFilter) {
        this(directory, fileFilter, null);
    }

    public LogFileAlterationObserver(File directory, FileFilter fileFilter, IOCase caseSensitivity) {
        this(new FileEntry(directory), fileFilter, caseSensitivity);
    }

    protected LogFileAlterationObserver(FileEntry rootEntry, FileFilter fileFilter, IOCase caseSensitivity) {
        super(rootEntry, fileFilter, caseSensitivity);
        if (!RemotingUtil.isWindowsPlatform()) {
            log.info("LogFileAlterationObserver set comparator:{}", InodeFileComparator.INODE_COMPARATOR);
            ReflectUtil.setFieldValue((Object)((Object)this), (String)"comparator", InodeFileComparator.INODE_COMPARATOR);
        }
    }

    public void checkAndNotify() {
        for (FileAlterationListener listener : this.getListeners()) {
            listener.onStart((FileAlterationObserver)this);
        }
        File rootFile = this.getDirectory();
        if (null == this.childRootEntry) {
            this.childRootEntry = (FileEntry)ReflectUtil.getFieldValue((Object)((Object)this), (String)"rootEntry");
        }
        if (rootFile.exists()) {
            this.checkAndNotify(this.childRootEntry, this.childRootEntry.getChildren(), this.listFiles(rootFile));
        } else if (this.childRootEntry.isExists()) {
            this.checkAndNotify(this.childRootEntry, this.childRootEntry.getChildren(), FileUtils.EMPTY_FILE_ARRAY);
        }
        for (FileAlterationListener listener : this.getListeners()) {
            listener.onStop((FileAlterationObserver)this);
        }
    }

    private void checkAndNotify(FileEntry parent, FileEntry[] previous, File[] files) {
        int c = 0;
        if (null == this.childComparator) {
            this.childComparator = (Comparator)ReflectUtil.getFieldValue((Object)((Object)this), (String)"comparator");
        }
        FileEntry[] current = files.length > 0 ? new FileEntry[files.length] : EMPTY_ENTRIES;
        for (FileEntry entry : previous) {
            while (c < files.length && this.childComparator.compare(entry.getFile(), files[c]) > 0) {
                current[c] = this.createFileEntry(parent, files[c]);
                this.doCreate(current[c]);
                ++c;
            }
            if (c < files.length && this.childComparator.compare(entry.getFile(), files[c]) == 0) {
                this.checkAndNotify(entry, entry.getChildren(), this.listFiles(files[c]));
                current[c] = entry;
                ++c;
                continue;
            }
            this.checkAndNotify(entry, entry.getChildren(), FileUtils.EMPTY_FILE_ARRAY);
        }
        while (c < files.length) {
            current[c] = this.createFileEntry(parent, files[c]);
            this.doCreate(current[c]);
            ++c;
        }
        parent.setChildren(current);
    }

    private File[] listFiles(File file) {
        File[] children = null;
        if (file.isDirectory()) {
            File[] fileArray = children = this.getFileFilter() == null ? file.listFiles() : file.listFiles(this.getFileFilter());
        }
        if (children == null) {
            children = FileUtils.EMPTY_FILE_ARRAY;
        }
        if (children.length > 1) {
            Arrays.sort(children, NameFileComparator.NAME_SYSTEM_COMPARATOR);
        }
        return children;
    }

    private FileEntry createFileEntry(FileEntry parent, File file) {
        FileEntry entry = parent.newChildInstance(file);
        entry.refresh(file);
        File[] files = this.listFiles(file);
        FileEntry[] children = files.length > 0 ? new FileEntry[files.length] : EMPTY_ENTRIES;
        for (int i = 0; i < files.length; ++i) {
            children[i] = this.createFileEntry(entry, files[i]);
        }
        entry.setChildren(children);
        return entry;
    }

    private void doCreate(FileEntry entry) {
        FileEntry[] children;
        for (FileAlterationListener listener : this.getListeners()) {
            if (entry.isDirectory()) {
                listener.onDirectoryCreate(entry.getFile());
                continue;
            }
            listener.onFileCreate(entry.getFile());
        }
        for (FileEntry aChildren : children = entry.getChildren()) {
            this.doCreate(aChildren);
        }
    }
}

