/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel;

import cn.hutool.system.SystemUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaomi.data.push.common.SafeRun;
import com.xiaomi.mone.file.MLog;
import com.xiaomi.mone.file.ReadListener;
import com.xiaomi.mone.file.ReadResult;
import com.xiaomi.mone.file.common.FileInfo;
import com.xiaomi.mone.file.common.FileInfoCache;
import com.xiaomi.mone.file.event.EventListener;
import com.xiaomi.mone.file.listener.DefaultMonitorListener;
import com.xiaomi.mone.file.ozhera.HeraFileMonitor;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.agent.channel.AbstractChannelService;
import org.apache.ozhera.log.agent.channel.ChannelDefine;
import org.apache.ozhera.log.agent.channel.file.MonitorFile;
import org.apache.ozhera.log.agent.channel.memory.AgentMemoryService;
import org.apache.ozhera.log.agent.channel.memory.ChannelMemory;
import org.apache.ozhera.log.agent.common.ChannelUtil;
import org.apache.ozhera.log.agent.common.ExecutorUtil;
import org.apache.ozhera.log.agent.export.MsgExporter;
import org.apache.ozhera.log.agent.filter.FilterChain;
import org.apache.ozhera.log.agent.input.Input;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.api.model.meta.FilterConf;
import org.apache.ozhera.log.api.model.msg.LineMessage;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.common.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildcardChannelServiceImpl
extends AbstractChannelService {
    private static final Logger log = LoggerFactory.getLogger(WildcardChannelServiceImpl.class);
    private AgentMemoryService memoryService;
    private MsgExporter msgExporter;
    private ChannelDefine channelDefine;
    private ChannelMemory channelMemory;
    private FilterChain chain;
    private String logPattern;
    private String linePrefix;
    private String memoryBasePath;
    private static final String POINTER_FILENAME_PREFIX = ".ozhera_pointer";
    private List<LineMessage> lineMessageList = new ArrayList<LineMessage>();
    private ScheduledFuture<?> scheduledFuture;
    private ScheduledFuture<?> lastFileLineScheduledFuture;
    private List<Future<?>> fileCollFutures = Lists.newArrayList();
    private volatile long lastSendTime = System.currentTimeMillis();
    private volatile long logCounts = 0L;
    private ReentrantLock reentrantLock = new ReentrantLock();
    private DefaultMonitorListener defaultMonitorListener;
    private HeraFileMonitor fileMonitor;

    public WildcardChannelServiceImpl(MsgExporter msgExporter, AgentMemoryService memoryService, ChannelDefine channelDefine, FilterChain chain, String memoryBasePath) {
        this.memoryService = memoryService;
        this.msgExporter = msgExporter;
        this.channelDefine = channelDefine;
        this.chain = chain;
        this.memoryBasePath = memoryBasePath;
    }

    @Override
    public void start() {
        Long channelId = this.channelDefine.getChannelId();
        Input input = this.channelDefine.getInput();
        this.logPattern = input.getLogPattern();
        this.linePrefix = input.getLinePrefix();
        List patterns = PathUtils.parseLevel5Directory((String)this.logPattern);
        log.info("channel start, logPattern:{}\uff0cfileList:{}, channelId:{}, instanceId:{}", new Object[]{this.logPattern, Constant.GSON.toJson((Object)patterns), channelId, this.instanceId()});
        this.channelMemory = this.memoryService.getMemory(channelId);
        if (null == this.channelMemory) {
            this.channelMemory = this.initChannelMemory(channelId, input, patterns, this.channelDefine);
        }
        this.memoryService.cleanChannelMemoryContent(channelId, patterns);
        this.startCollectFile(channelId, input, this.getTailPodIp(this.logPattern));
        this.startExportQueueDataThread();
        this.memoryService.refreshMemory(this.channelMemory);
        log.warn("channelId:{}, channelInstanceId:{} start success! channelDefine:{}", new Object[]{channelId, this.instanceId(), Constant.GSON.toJson((Object)this.channelDefine)});
    }

    private void startCollectFile(Long channelId, Input input, String ip) {
        try {
            String restartFile = this.buildRestartFilePath();
            FileInfoCache.ins().load(restartFile);
            this.fileMonitor = this.createFileMonitor(input.getPatternCode(), ip);
            String fileExpression = this.buildFileExpression(input.getLogPattern());
            List<String> monitorPaths = this.buildMonitorPaths(input.getLogPattern());
            WildcardChannelServiceImpl.wildcardGraceShutdown(monitorPaths, fileExpression);
            this.saveCollProgress();
            log.info("fileExpression:{}", (Object)fileExpression);
            Pattern pattern = Pattern.compile(fileExpression);
            for (String monitorPath : monitorPaths) {
                this.fileCollFutures.add(ExecutorUtil.submit(() -> this.monitorFileChanges(this.fileMonitor, monitorPath, pattern)));
            }
        }
        catch (Exception e) {
            log.error("startCollectFile error, channelId: {}, input: {}, ip: {}", new Object[]{channelId, Constant.GSON.toJson((Object)input), ip, e});
        }
    }

    private void saveCollProgress() {
        ExecutorUtil.scheduleAtFixedRate(() -> SafeRun.run(() -> {
            try {
                for (ReadListener readListener : this.defaultMonitorListener.getReadListenerList()) {
                    readListener.saveProgress();
                }
                this.cleanUpInvalidFileInfos();
                FileInfoCache.ins().shutdown();
            }
            catch (Exception e) {
                log.error("saveCollProgress error", (Throwable)e);
            }
        }), 60L, 30L, TimeUnit.SECONDS);
    }

    private void cleanUpInvalidFileInfos() {
        ConcurrentMap caches = FileInfoCache.ins().caches();
        for (Map.Entry entry : caches.entrySet()) {
            FileInfo fileInfo = (FileInfo)entry.getValue();
            File file = new File(fileInfo.getFileName());
            if (StringUtils.isEmpty((CharSequence)fileInfo.getFileName()) || file.exists()) continue;
            FileInfoCache.ins().remove((String)entry.getKey());
        }
    }

    private String buildRestartFilePath() {
        return String.format("%s%s%s", this.memoryBasePath, "/milog/memory/", POINTER_FILENAME_PREFIX);
    }

    private String buildFileExpression(String logPattern) {
        String[] expressSplit = logPattern.split(",");
        if (expressSplit.length == 1) {
            return ChannelUtil.buildSingleTimeExpress(logPattern);
        }
        List<String> expressions = Arrays.stream(expressSplit).map(ChannelUtil::buildSingleTimeExpress).map(s -> {
            String multipleFileName = StringUtils.substringAfterLast((String)s, (String)"/");
            return multipleFileName.contains("*") ? s : s + ".*";
        }).distinct().toList();
        return expressions.size() == 1 ? expressions.get(0) : expressions.stream().collect(Collectors.joining("|", "(", ")"));
    }

    private void monitorFileChanges(HeraFileMonitor monitor, String monitorPath, Pattern pattern) {
        try {
            log.info("monitorFileChanges,directory:{}", (Object)monitorPath);
            monitor.reg(monitorPath, filePath -> {
                if (SystemUtil.getOsInfo().isWindows()) {
                    return true;
                }
                boolean matches = pattern.matcher((CharSequence)filePath).matches();
                log.debug("file: {}, matches: {}", filePath, (Object)matches);
                return matches;
            });
        }
        catch (IOException | InterruptedException e) {
            log.error("Error while monitoring files, monitorPath: {}", (Object)monitorPath, (Object)e);
        }
    }

    private List<String> buildMonitorPaths(String filePathExpressName) {
        String[] pathExpress = filePathExpressName.split(",");
        List<String> monitorPaths = Arrays.stream(pathExpress).map(express -> {
            String monitorPath = StringUtils.substringBeforeLast((String)express, (String)"/");
            return monitorPath.endsWith("/") ? monitorPath : monitorPath + "/";
        }).flatMap(monitorPath -> PathUtils.buildMultipleDirectories((String)monitorPath).stream()).distinct().collect(Collectors.toList());
        return monitorPaths;
    }

    private HeraFileMonitor createFileMonitor(String patternCode, String ip) {
        MLog mLog = new MLog();
        if (StringUtils.isNotBlank((CharSequence)this.linePrefix)) {
            mLog.setCustomLinePattern(this.linePrefix);
        }
        HeraFileMonitor monitor = new HeraFileMonitor();
        AtomicReference<ReadResult> readResult = new AtomicReference<ReadResult>();
        this.defaultMonitorListener = new DefaultMonitorListener(monitor, event -> {
            readResult.set(event.getReadResult());
            if (readResult.get() == null) {
                log.info("Empty data");
                return;
            }
            this.processLogLines(readResult, patternCode, ip, mLog);
        });
        monitor.setListener((EventListener)this.defaultMonitorListener);
        this.scheduleLastLineSender(mLog, readResult, patternCode, ip);
        return monitor;
    }

    private void processLogLines(AtomicReference<ReadResult> readResult, String patternCode, String ip, MLog mLog) {
        long currentTime = System.currentTimeMillis();
        ReadResult result = readResult.get();
        LogTypeEnum logTypeEnum = this.getLogTypeEnum();
        result.getLines().forEach(line -> {
            if (LogTypeEnum.APP_LOG_MULTI == logTypeEnum || LogTypeEnum.OPENTELEMETRY == logTypeEnum) {
                line = mLog.append2(line);
            }
            if (line != null) {
                try {
                    this.reentrantLock.lock();
                    this.wrapDataToSend((String)line, readResult, patternCode, ip, currentTime);
                }
                finally {
                    this.reentrantLock.unlock();
                }
            } else {
                log.debug("Biz log channelId:{}, not a new line", (Object)this.channelDefine.getChannelId());
            }
        });
    }

    private void scheduleLastLineSender(MLog mLog, AtomicReference<ReadResult> readResult, String patternCode, String ip) {
        this.lastFileLineScheduledFuture = ExecutorUtil.scheduleAtFixedRate(() -> {
            Long appendTime = mLog.getAppendTime();
            if (appendTime != null && Instant.now().toEpochMilli() - appendTime > 10000L && this.reentrantLock.tryLock()) {
                try {
                    String remainMsg = mLog.takeRemainMsg2();
                    if (null != remainMsg) {
                        log.info("start send last line, fileName:{}, patternCode:{}, data:{}", new Object[]{((ReadResult)readResult.get()).getFilePathName(), patternCode, remainMsg});
                        this.wrapDataToSend(remainMsg, readResult, patternCode, ip, Instant.now().toEpochMilli());
                    }
                }
                finally {
                    this.reentrantLock.unlock();
                }
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    private void wrapDataToSend(String lineMsg, AtomicReference<ReadResult> readResult, String patternCode, String localIp, long ct) {
        String filePathName = readResult.get().getFilePathName();
        LineMessage lineMessage = this.createLineMessage(lineMsg, readResult, filePathName, patternCode, localIp, ct);
        this.updateChannelMemory(this.channelMemory, filePathName, this.getLogTypeEnum(), ct, readResult);
        this.lineMessageList.add(lineMessage);
        int batchSize = this.msgExporter.batchExportSize();
        if (this.lineMessageList.size() > batchSize) {
            List<LineMessage> subList = this.lineMessageList.subList(0, batchSize);
            this.doExport(subList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport(List<LineMessage> subList) {
        try {
            if (CollectionUtils.isEmpty(subList)) {
                return;
            }
            this.chain.doFilter();
            long current = System.currentTimeMillis();
            this.msgExporter.export(subList);
            this.logCounts += (long)subList.size();
            this.lastSendTime = System.currentTimeMillis();
            this.channelMemory.setCurrentTime(this.lastSendTime);
            log.info("doExport channelId:{}, send {} message, cost:{}, total send:{}, instanceId:{},", new Object[]{this.channelDefine.getChannelId(), subList.size(), this.lastSendTime - current, this.logCounts, this.instanceId()});
        }
        catch (Exception e) {
            log.error("doExport Exception", (Throwable)e);
        }
        finally {
            subList.clear();
        }
    }

    private void startExportQueueDataThread() {
        this.scheduledFuture = ExecutorUtil.scheduleAtFixedRate(() -> {
            if (System.currentTimeMillis() - this.lastSendTime < 10000L || CollectionUtils.isEmpty(this.lineMessageList)) {
                return;
            }
            if (CollectionUtils.isNotEmpty(this.lineMessageList) && this.reentrantLock.tryLock()) {
                try {
                    this.doExport(this.lineMessageList);
                }
                finally {
                    this.reentrantLock.unlock();
                }
            }
        }, 10L, 7L, TimeUnit.SECONDS);
    }

    @Override
    public ChannelDefine getChannelDefine() {
        return this.channelDefine;
    }

    @Override
    public ChannelMemory getChannelMemory() {
        return this.channelMemory;
    }

    @Override
    public Map<String, Long> getExpireFileMap() {
        return Maps.newHashMap();
    }

    @Override
    public void cancelFile(String file) {
    }

    @Override
    public Long getLogCounts() {
        return this.logCounts;
    }

    @Override
    public void refresh(ChannelDefine channelDefine, MsgExporter msgExporter) {
        this.channelDefine = channelDefine;
        if (null != msgExporter) {
            this.msgExporter.close();
            this.msgExporter = msgExporter;
        }
    }

    @Override
    public void stopFile(List<String> filePrefixList) {
    }

    @Override
    public void filterRefresh(List<FilterConf> confs) {
        try {
            this.chain.loadFilterList(confs);
            this.chain.reset();
        }
        catch (Exception e) {
            log.error("filter refresh err,new conf:{}", confs, (Object)e);
        }
    }

    @Override
    public void reOpen(String filePath) {
    }

    @Override
    public List<MonitorFile> getMonitorPathList() {
        return Lists.newArrayList();
    }

    @Override
    public void cleanCollectFiles() {
    }

    @Override
    public void deleteCollFile(String directory) {
    }

    @Override
    public void close() {
        this.fileMonitor.stop();
        log.info("Delete the current collection task,channelId:{}", (Object)this.channelDefine.getChannelId());
        this.msgExporter.close();
        this.memoryService.refreshMemory(this.channelMemory);
        if (null != this.scheduledFuture) {
            this.scheduledFuture.cancel(false);
        }
        if (null != this.lastFileLineScheduledFuture) {
            this.lastFileLineScheduledFuture.cancel(false);
        }
        for (Future<?> fileCollFuture : this.fileCollFutures) {
            fileCollFuture.cancel(false);
        }
        this.lineMessageList.clear();
    }
}

