/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Pair;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.xiaomi.data.push.common.SafeRun;
import com.xiaomi.mone.file.DefaultReadListener;
import com.xiaomi.mone.file.ILogFile;
import com.xiaomi.mone.file.LogFile;
import com.xiaomi.mone.file.MLog;
import com.xiaomi.mone.file.ReadListener;
import com.xiaomi.mone.file.ReadResult;
import com.xiaomi.youpin.docean.Ioc;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.agent.channel.AbstractChannelService;
import org.apache.ozhera.log.agent.channel.ChannelDefine;
import org.apache.ozhera.log.agent.channel.ChannelEngine;
import org.apache.ozhera.log.agent.channel.file.InodeFileComparator;
import org.apache.ozhera.log.agent.channel.file.MonitorFile;
import org.apache.ozhera.log.agent.channel.memory.AgentMemoryService;
import org.apache.ozhera.log.agent.channel.memory.ChannelMemory;
import org.apache.ozhera.log.agent.common.ChannelUtil;
import org.apache.ozhera.log.agent.common.ExecutorUtil;
import org.apache.ozhera.log.agent.export.MsgExporter;
import org.apache.ozhera.log.agent.filter.FilterChain;
import org.apache.ozhera.log.agent.input.Input;
import org.apache.ozhera.log.api.enums.K8sPodTypeEnum;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.api.model.meta.FilterConf;
import org.apache.ozhera.log.api.model.msg.LineMessage;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.common.PathUtils;
import org.apache.ozhera.log.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelServiceImpl
extends AbstractChannelService {
    private static final Logger log = LoggerFactory.getLogger(ChannelServiceImpl.class);
    private AgentMemoryService memoryService;
    private MsgExporter msgExporter;
    private ChannelDefine channelDefine;
    private ChannelMemory channelMemory;
    private final ConcurrentHashMap<String, ILogFile> logFileMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Future> futureMap = new ConcurrentHashMap();
    private Set<String> delFileCollList = new CopyOnWriteArraySet<String>();
    private final Map<String, Long> reOpenMap = new HashMap<String, Long>();
    private final Map<String, Long> fileReadMap = new ConcurrentHashMap<String, Long>();
    private final Map<String, Pair<MLog, AtomicReference<ReadResult>>> resultMap = new ConcurrentHashMap<String, Pair<MLog, AtomicReference<ReadResult>>>();
    private ScheduledFuture<?> lastFileLineScheduledFuture;
    private Gson gson = Constant.GSON;
    private List<LineMessage> lineMessageList = new ArrayList<LineMessage>();
    private ReentrantLock fileColLock = new ReentrantLock();
    private ReentrantLock fileReopenLock = new ReentrantLock();
    private volatile long lastSendTime = System.currentTimeMillis();
    private volatile long logCounts = 0L;
    private ScheduledFuture<?> scheduledFuture;
    private boolean collectOnce;
    private FilterChain chain;
    private List<MonitorFile> monitorFileList;
    private LogTypeEnum logTypeEnum;
    private String logPattern;
    private String logSplitExpress;
    private String linePrefix;

    public ChannelServiceImpl(MsgExporter msgExporter, AgentMemoryService memoryService, ChannelDefine channelDefine, FilterChain chain) {
        this.memoryService = memoryService;
        this.msgExporter = msgExporter;
        this.channelDefine = channelDefine;
        this.chain = chain;
        this.monitorFileList = Lists.newArrayList();
    }

    @Override
    public void refresh(ChannelDefine channelDefine, MsgExporter msgExporter) {
        this.channelDefine = channelDefine;
        if (null != msgExporter) {
            this.msgExporter.close();
            this.msgExporter = msgExporter;
        }
    }

    @Override
    public void stopFile(List<String> filePrefixList) {
        Map<String, ChannelMemory.FileProgress> fileProgressMap = this.channelMemory.getFileProgressMap();
        if (null == fileProgressMap) {
            fileProgressMap = new HashMap<String, ChannelMemory.FileProgress>();
        }
        Iterator<Map.Entry<String, ILogFile>> it = this.logFileMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ILogFile> entry = it.next();
            String filePath = entry.getKey();
            for (String filePrefix : filePrefixList) {
                if (!filePath.startsWith(filePrefix)) continue;
                entry.getValue().setStop(true);
                this.futureMap.get(filePath).cancel(false);
                log.warn("channel:{} stop file:{} success", (Object)this.channelDefine.getChannelId(), (Object)filePath);
                ChannelMemory.FileProgress fileProgress = fileProgressMap.get(filePath);
                if (null != fileProgress) {
                    fileProgress.setFinished(true);
                }
                it.remove();
            }
        }
    }

    @Override
    public void start() {
        Long channelId = this.channelDefine.getChannelId();
        Input input = this.channelDefine.getInput();
        this.logPattern = input.getLogPattern();
        this.logSplitExpress = input.getLogSplitExpress();
        this.linePrefix = input.getLinePrefix();
        String logType = this.channelDefine.getInput().getType();
        this.logTypeEnum = LogTypeEnum.name2enum((String)logType);
        this.collectOnce = StringUtils.substringAfterLast((String)this.logPattern, (String)"/").contains("*");
        List patterns = PathUtils.parseLevel5Directory((String)this.logPattern);
        if (CollectionUtils.isEmpty((Collection)patterns)) {
            log.info("config pattern:{},current files not exist", (Object)this.logPattern);
        }
        log.info("channel start, logPattern:{}\uff0cfileList:{}, channelId:{}, instanceId:{}", new Object[]{this.logPattern, patterns, channelId, this.instanceId()});
        this.logMonitorPathDisassembled(this.logSplitExpress, patterns, this.logPattern);
        this.channelMemory = this.memoryService.getMemory(channelId);
        if (null == this.channelMemory) {
            log.info("get channelMemory empty,filePath:{}", (Object)this.logPattern);
            this.channelMemory = this.initChannelMemory(channelId, input, patterns, this.channelDefine);
        }
        this.memoryService.cleanChannelMemoryContent(channelId, patterns);
        this.startCollectFile(channelId, input, patterns);
        this.startExportQueueDataThread();
        this.memoryService.refreshMemory(this.channelMemory);
        log.warn("channelId:{}, channelInstanceId:{} start success! channelDefine:{}", new Object[]{channelId, this.instanceId(), this.gson.toJson((Object)this.channelDefine)});
    }

    @Override
    public void cleanCollectFiles() {
        for (String path : this.delFileCollList) {
            this.delCollFile(path);
        }
    }

    @Override
    public void deleteCollFile(String directory) {
        log.info("channelId:{},deleteCollFile,directory:{}", (Object)this.channelDefine.getChannelId(), (Object)directory);
        for (Map.Entry<String, ILogFile> logFileEntry : this.logFileMap.entrySet()) {
            if (!logFileEntry.getKey().contains(directory)) continue;
            this.delFileCollList.add(logFileEntry.getKey());
            log.info("channelId:{},delFileCollList:{}", (Object)this.channelDefine.getChannelId(), (Object)this.gson.toJson(this.delFileCollList));
        }
    }

    private void startExportQueueDataThread() {
        this.scheduledFuture = ExecutorUtil.scheduleAtFixedRate(() -> {
            if (System.currentTimeMillis() - this.lastSendTime < 10000L || CollectionUtils.isEmpty(this.lineMessageList)) {
                return;
            }
            if (CollectionUtils.isNotEmpty(this.lineMessageList) && this.fileColLock.tryLock()) {
                try {
                    this.doExport(this.lineMessageList);
                }
                finally {
                    this.fileColLock.unlock();
                }
            }
        }, 10L, 7L, TimeUnit.SECONDS);
    }

    private void startCollectFile(Long channelId, Input input, List<String> patterns) {
        for (int i = 0; i < patterns.size(); ++i) {
            log.info("startCollectFile,total file:{},start:{},remain:{}", new Object[]{patterns.size(), i + 1, patterns.size() - (i + 1)});
            this.readFile(input.getPatternCode(), this.getTailPodIp(patterns.get(i)), patterns.get(i), channelId);
            InodeFileComparator.addFile(patterns.get(i));
        }
        this.lastLineRemainSendSchedule(input.getPatternCode());
    }

    private void handleAllFileCollectMonitor(String patternCode, String newFilePath, Long channelId) {
        String ip = this.getTailPodIp(newFilePath);
        if (this.logFileMap.keySet().stream().anyMatch(key -> Objects.equals(newFilePath, key))) {
            log.info("collectOnce open file:{}", (Object)newFilePath);
            this.logFileMap.get(newFilePath).setReOpen(true);
        } else {
            this.readFile(patternCode, ip, newFilePath, channelId);
        }
    }

    private void logMonitorPathDisassembled(String logSplitExpress, List<String> realFilePaths, String configPath) {
        ArrayList cleanedPathList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)logSplitExpress)) {
            PathUtils.dismantlingStrWithSymbol((String)logSplitExpress, (List)cleanedPathList);
        }
        if (LogTypeEnum.OPENTELEMETRY == this.logTypeEnum || realFilePaths.isEmpty()) {
            this.opentelemetryMonitor(configPath);
            return;
        }
        if (this.collectOnce) {
            this.collectOnceFileMonitor(configPath);
            return;
        }
        for (int i = 0; i < realFilePaths.size(); ++i) {
            String perFilePathExpress;
            try {
                perFilePathExpress = (String)cleanedPathList.get(i);
                perFilePathExpress = String.format("(%s|%s)", perFilePathExpress, String.format("%s.*", realFilePaths.get(i)));
            }
            catch (Exception e) {
                perFilePathExpress = String.format("%s.*", realFilePaths.get(i));
            }
            this.monitorFileList.add(MonitorFile.of(realFilePaths.get(i), perFilePathExpress, this.logTypeEnum, this.collectOnce));
        }
    }

    private void collectOnceFileMonitor(String configPath) {
        String singleTimeExpress = ChannelUtil.buildSingleTimeExpress(configPath);
        this.monitorFileList.add(MonitorFile.of(configPath, singleTimeExpress, this.logTypeEnum, this.collectOnce));
    }

    private void opentelemetryMonitor(String configPath) {
        List<String> cleanedPathList = ChannelUtil.buildLogExpressList(configPath);
        this.monitorFileList.add(MonitorFile.of(configPath, cleanedPathList.get(0), this.logTypeEnum, this.collectOnce));
    }

    private ReadListener initFileReadListener(MLog mLog, String patternCode, String ip, String pattern) {
        AtomicReference readResult = new AtomicReference();
        DefaultReadListener listener = new DefaultReadListener(event -> {
            readResult.set(event.getReadResult());
            if (null == readResult.get()) {
                log.info("empty data");
                return;
            }
            long ct = System.currentTimeMillis();
            ((ReadResult)readResult.get()).getLines().stream().forEach(l -> {
                String logType = this.channelDefine.getInput().getType();
                LogTypeEnum logTypeEnum = LogTypeEnum.name2enum((String)logType);
                if (LogTypeEnum.APP_LOG_MULTI == logTypeEnum || LogTypeEnum.OPENTELEMETRY == logTypeEnum) {
                    l = mLog.append2(l);
                }
                if (null != l) {
                    try {
                        this.fileColLock.lock();
                        this.wrapDataToSend((String)l, readResult, pattern, patternCode, ip, ct);
                    }
                    finally {
                        this.fileColLock.unlock();
                    }
                } else {
                    log.debug("biz log channelId:{}, not new line:{}", (Object)this.channelDefine.getChannelId(), l);
                }
            });
        });
        this.resultMap.put(pattern, (Pair<MLog, AtomicReference<ReadResult>>)Pair.of((Object)mLog, readResult));
        return listener;
    }

    private void lastLineRemainSendSchedule(String patternCode) {
        this.lastFileLineScheduledFuture = ExecutorUtil.scheduleAtFixedRate(() -> SafeRun.run(() -> {
            for (Map.Entry<String, Pair<MLog, AtomicReference<ReadResult>>> referenceEntry : this.resultMap.entrySet()) {
                MLog mLog = (MLog)referenceEntry.getValue().getKey();
                String pattern = referenceEntry.getKey();
                Long appendTime = mLog.getAppendTime();
                if (null == appendTime || Instant.now().toEpochMilli() - appendTime <= 10000L || !this.fileColLock.tryLock()) continue;
                try {
                    String remainMsg = mLog.takeRemainMsg2();
                    if (null == remainMsg) continue;
                    log.info("start send last line,pattern:{},patternCode:{},data:{}", new Object[]{pattern, patternCode, remainMsg});
                    this.wrapDataToSend(remainMsg, (AtomicReference)referenceEntry.getValue().getValue(), pattern, patternCode, this.getTailPodIp(pattern), appendTime);
                }
                finally {
                    this.fileColLock.unlock();
                }
            }
        }), 30L, 30L, TimeUnit.SECONDS);
    }

    private void wrapDataToSend(String lineMsg, AtomicReference<ReadResult> readResult, String pattern, String patternCode, String ip, long ct) {
        LineMessage lineMessage = this.createLineMessage(lineMsg, readResult, pattern, patternCode, ip, ct);
        this.updateChannelMemory(this.channelMemory, pattern, this.logTypeEnum, ct, readResult);
        this.lineMessageList.add(lineMessage);
        this.fileReadMap.put(pattern, ct);
        int batchSize = this.msgExporter.batchExportSize();
        if (this.lineMessageList.size() > batchSize) {
            List<LineMessage> subList = this.lineMessageList.subList(0, batchSize);
            this.doExport(subList);
        }
    }

    private void readFile(String patternCode, String ip, String filePath, Long channelId) {
        MLog mLog = new MLog();
        if (StringUtils.isNotBlank((CharSequence)this.linePrefix)) {
            mLog.setCustomLinePattern(this.linePrefix);
        }
        String usedIp = StringUtils.isBlank((CharSequence)ip) ? NetUtil.getLocalIp() : ip;
        ReadListener listener = this.initFileReadListener(mLog, patternCode, usedIp, filePath);
        Map<String, ChannelMemory.FileProgress> fileProgressMap = this.channelMemory.getFileProgressMap();
        this.printMapToJson(fileProgressMap, this.collectOnce);
        ILogFile logFile = this.getLogFile(filePath, listener, fileProgressMap);
        if (null == logFile) {
            log.warn("file:{} marked stop to collect", (Object)filePath);
            return;
        }
        if (FileUtil.exist((String)filePath)) {
            this.stopOldCurrentFileThread(filePath);
            log.info("start to collect file,channelId:{},fileName:{}", (Object)channelId, (Object)filePath);
            this.logFileMap.put(filePath, logFile);
            Future<?> future = ExecutorUtil.submit(() -> {
                try {
                    log.info("filePath:{},is VirtualThread {}, thread:{},id:{}", new Object[]{filePath, Thread.currentThread().isVirtual(), Thread.currentThread(), Thread.currentThread().threadId()});
                    logFile.readLine();
                }
                catch (Exception e) {
                    logFile.setExceptionFinish();
                    log.error("logFile read line err,channelId:{},localIp:{},file:{},patternCode:{}", new Object[]{channelId, usedIp, fileProgressMap, patternCode, e});
                }
            });
            this.futureMap.put(filePath, future);
        } else {
            log.info("file not exist,file:{}", (Object)filePath);
        }
    }

    private void stopOldCurrentFileThread(String filePath) {
        Future future;
        ILogFile logFile = this.logFileMap.get(filePath);
        if (null != logFile) {
            logFile.setStop(true);
        }
        if (null != (future = this.futureMap.get(filePath))) {
            future.cancel(false);
        }
    }

    private void printMapToJson(Map<String, ChannelMemory.FileProgress> map, boolean collectOnce) {
        HashMap<String, ChannelMemory.FileProgress> snapshot;
        if (map == null || map.isEmpty()) {
            return;
        }
        try {
            snapshot = new HashMap<String, ChannelMemory.FileProgress>(map);
        }
        catch (ConcurrentModificationException e) {
            log.error("Failed to create snapshot of fileProgressMap", (Throwable)e);
            return;
        }
        if (!collectOnce && !snapshot.isEmpty()) {
            String jsonMap = this.gson.toJson(snapshot);
            log.info("fileProgressMap: {}", (Object)jsonMap);
        }
    }

    private ILogFile getLogFile(String filePath, ReadListener listener, Map<String, ChannelMemory.FileProgress> fileProgressMap) {
        ChannelMemory.UnixFileNode memoryUnixFileNode;
        long lineNumber;
        ChannelMemory.FileProgress progressInfo = fileProgressMap.get(filePath);
        if ((progressInfo == null || progressInfo.getFinished() != null && progressInfo.getFinished().booleanValue()) && StringUtils.isNotBlank((CharSequence)this.channelDefine.getPodType()) && K8sPodTypeEnum.valueOf((String)this.channelDefine.getPodType().toUpperCase()) != K8sPodTypeEnum.STATEFUL) {
            return null;
        }
        long pointer = progressInfo != null ? progressInfo.getPointer() : 0L;
        long l = lineNumber = progressInfo != null ? progressInfo.getCurrentRowNum() : 0L;
        if (progressInfo != null && (memoryUnixFileNode = progressInfo.getUnixFileNode()) != null && memoryUnixFileNode.getSt_ino() != null) {
            log.info("memory file inode info, filePath:{},:{}", (Object)filePath, (Object)this.gson.toJson((Object)memoryUnixFileNode));
            ChannelMemory.UnixFileNode currentUnixFileNode = ChannelUtil.buildUnixFileNode(filePath);
            if (currentUnixFileNode != null && currentUnixFileNode.getSt_ino() != null && !Objects.equals(memoryUnixFileNode.getSt_ino(), currentUnixFileNode.getSt_ino())) {
                pointer = 0L;
                lineNumber = 0L;
                log.info("read file start from head, filePath:{}, memory:{}, current:{}", new Object[]{filePath, this.gson.toJson((Object)memoryUnixFileNode), this.gson.toJson((Object)currentUnixFileNode)});
            }
        }
        ChannelEngine channelEngine = (ChannelEngine)Ioc.ins().getBean(ChannelEngine.class);
        ILogFile logFile = channelEngine.logFile();
        log.info("initLogFile filePath:{},pointer:{},lineNumber:{}", new Object[]{filePath, pointer, lineNumber});
        logFile.initLogFile(filePath, listener, pointer, lineNumber);
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport(List<LineMessage> subList) {
        try {
            if (CollectionUtils.isEmpty(subList)) {
                return;
            }
            this.chain.doFilter();
            long current = System.currentTimeMillis();
            this.msgExporter.export(subList);
            this.logCounts += (long)subList.size();
            this.lastSendTime = System.currentTimeMillis();
            this.channelMemory.setCurrentTime(this.lastSendTime);
            log.info("doExport channelId:{}, send {} message, cost:{}, total send:{}, instanceId:{},", new Object[]{this.channelDefine.getChannelId(), subList.size(), this.lastSendTime - current, this.logCounts, this.instanceId()});
        }
        catch (Exception e) {
            log.error("doExport Exception:{}", (Throwable)e);
        }
        finally {
            subList.clear();
        }
    }

    @Override
    public void close() {
        log.info("Delete the current collection task,channelId:{}", (Object)this.getChannelId());
        for (Map.Entry<String, ILogFile> fileEntry : this.logFileMap.entrySet()) {
            fileEntry.getValue().setStop(true);
            InodeFileComparator.removeFile(fileEntry.getKey());
        }
        this.msgExporter.close();
        this.memoryService.refreshMemory(this.channelMemory);
        if (null != this.scheduledFuture) {
            this.scheduledFuture.cancel(false);
        }
        if (null != this.lastFileLineScheduledFuture) {
            this.lastFileLineScheduledFuture.cancel(false);
        }
        for (Future future : this.futureMap.values()) {
            future.cancel(false);
        }
        log.info("stop file monitor,fileName:", (Object)this.logFileMap.keySet().stream().collect(Collectors.joining(",")));
        this.lineMessageList.clear();
        this.reOpenMap.clear();
        this.fileReadMap.clear();
        this.resultMap.clear();
    }

    public Long getChannelId() {
        return this.channelDefine.getChannelId();
    }

    public MsgExporter getMsgExporter() {
        return this.msgExporter;
    }

    @Override
    public void filterRefresh(List<FilterConf> confs) {
        try {
            this.chain.loadFilterList(confs);
            this.chain.reset();
        }
        catch (Exception e) {
            log.error("filter refresh err,new conf:{}", confs, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reOpen(String filePath) {
        this.fileReopenLock.lock();
        try {
            String ip;
            long REOPEN_THRESHOLD = 10000L;
            if (this.reOpenMap.containsKey(filePath) && Instant.now().toEpochMilli() - this.reOpenMap.get(filePath) < 10000L) {
                log.info("The file has been opened too frequently.Please try again in 10 seconds.fileName:{},last time opening time.:{}", (Object)filePath, (Object)this.reOpenMap.get(filePath));
                return;
            }
            this.reOpenMap.put(filePath, Instant.now().toEpochMilli());
            log.info("reOpen file:{}", (Object)filePath);
            if (this.collectOnce) {
                this.handleAllFileCollectMonitor(this.channelDefine.getInput().getPatternCode(), filePath, this.getChannelId());
                return;
            }
            ILogFile logFile = this.logFileMap.get(filePath);
            String tailPodIp = this.getTailPodIp(filePath);
            String string = ip = StringUtils.isBlank((CharSequence)tailPodIp) ? NetUtil.getLocalIp() : tailPodIp;
            if (null == logFile || logFile.getExceptionFinish()) {
                this.readFile(this.channelDefine.getInput().getPatternCode(), ip, filePath, this.getChannelId());
                log.info("watch new file create for channelId:{},ip:{},path:{}", new Object[]{this.getChannelId(), filePath, ip});
            } else {
                this.handleExistingLogFileWithRetry(logFile, filePath, ip);
            }
        }
        finally {
            this.fileReopenLock.unlock();
        }
    }

    private void handleExistingLogFileWithRetry(ILogFile logFile, String filePath, String ip) {
        LogFile file = (LogFile)logFile;
        int maxRetries = 60;
        for (int currentRetries = 0; currentRetries < maxRetries; ++currentRetries) {
            if (file.getPointer() < file.getMaxPointer()) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    log.error("handleExistingLogFileWithRetry Sleep error", (Throwable)e);
                }
                continue;
            }
            logFile.setReOpen(true);
            log.info("file reOpen: channelId:{},ip:{},path:{}", new Object[]{this.getChannelId(), ip, filePath, file.getFile(), file.getBeforePointerHashCode()});
            break;
        }
    }

    @Override
    public List<MonitorFile> getMonitorPathList() {
        return this.monitorFileList;
    }

    @Override
    public ChannelDefine getChannelDefine() {
        return this.channelDefine;
    }

    @Override
    public ChannelMemory getChannelMemory() {
        return this.channelMemory;
    }

    @Override
    public Map<String, Long> getExpireFileMap() {
        HashMap<String, Long> expireMap = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry : this.fileReadMap.entrySet()) {
            if (Instant.now().toEpochMilli() - entry.getValue() <= TimeUnit.MINUTES.toMillis(10L)) continue;
            expireMap.put(entry.getKey(), entry.getValue());
        }
        return expireMap;
    }

    @Override
    public void cancelFile(String file) {
        log.info("cancelFile,file:{}", (Object)file);
        for (Map.Entry<String, ILogFile> logFileEntry : this.logFileMap.entrySet()) {
            if (!file.equals(logFileEntry.getKey())) continue;
            this.delFileCollList.add(logFileEntry.getKey());
        }
    }

    private void delCollFile(String path) {
        boolean shouldRemovePath = false;
        if (this.logFileMap.containsKey(path) && this.fileReadMap.containsKey(path)) {
            if (Instant.now().toEpochMilli() - this.fileReadMap.get(path) > TimeUnit.MINUTES.toMillis(1L)) {
                this.cleanFile(path::equals);
                shouldRemovePath = true;
                log.info("stop coll file:{}", (Object)path);
            }
        } else {
            shouldRemovePath = true;
        }
        if (shouldRemovePath) {
            log.info("channelId:{},delCollFile remove file:{}", (Object)this.channelDefine.getChannelId(), (Object)path);
            this.delFileCollList.removeIf(data -> StringUtils.equals((CharSequence)data, (CharSequence)path));
        }
    }

    private void cleanFile(Predicate<String> filter) {
        List<Object> delFiles = Lists.newArrayList();
        for (Map.Entry<String, ILogFile> entry : this.logFileMap.entrySet()) {
            if (!filter.test(entry.getKey())) continue;
            InodeFileComparator.removeFile(entry.getKey());
            entry.getValue().setStop(true);
            delFiles.add(entry.getKey());
            log.info("cleanFile,stop file:{}", (Object)entry.getKey());
        }
        for (String string : delFiles) {
            this.logFileMap.remove(string);
        }
        delFiles.clear();
        for (Map.Entry<String, Object> entry : this.futureMap.entrySet()) {
            if (!filter.test(entry.getKey())) continue;
            ((Future)entry.getValue()).cancel(false);
            delFiles.add(entry.getKey());
        }
        for (String string : delFiles) {
            this.futureMap.remove(string);
        }
        delFiles.clear();
        delFiles = this.reOpenMap.keySet().stream().filter(filePath -> filter.test((String)filePath)).collect(Collectors.toList());
        for (String string : delFiles) {
            this.reOpenMap.remove(string);
        }
        delFiles = this.fileReadMap.keySet().stream().filter(filePath -> filter.test((String)filePath)).collect(Collectors.toList());
        for (String string : delFiles) {
            this.fileReadMap.remove(string);
        }
        delFiles = this.resultMap.keySet().stream().filter(filePath -> filter.test((String)filePath)).collect(Collectors.toList());
        for (String string : delFiles) {
            this.resultMap.remove(string);
        }
    }

    @Override
    public Long getLogCounts() {
        return this.logCounts;
    }

    public ConcurrentHashMap<String, ILogFile> getLogFileMap() {
        return this.logFileMap;
    }

    public ConcurrentHashMap<String, Future> getFutureMap() {
        return this.futureMap;
    }
}

