/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc.session;

import com.xiaomi.youpin.docean.mvc.session.HttpSession;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DefaultHttpSession
implements HttpSession {
    private String sessionId;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private long createTime;
    private long updateTime;

    public DefaultHttpSession() {
        long now = System.currentTimeMillis();
        this.sessionId = UUID.randomUUID().toString();
        this.createTime = now;
        this.updateTime = now;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    @Override
    public void invalidate() {
        this.sessionId = null;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultHttpSession)) {
            return false;
        }
        DefaultHttpSession other = (DefaultHttpSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreateTime() != other.getCreateTime()) {
            return false;
        }
        if (this.getUpdateTime() != other.getUpdateTime()) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        Map<String, Object> this$attributes = this.getAttributes();
        Map<String, Object> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultHttpSession;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createTime = this.getCreateTime();
        result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
        long $updateTime = this.getUpdateTime();
        result = result * 59 + (int)($updateTime >>> 32 ^ $updateTime);
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        Map<String, Object> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "DefaultHttpSession(sessionId=" + this.getSessionId() + ", attributes=" + String.valueOf(this.getAttributes()) + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

