/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc.context;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketContext {
    private static final Logger log = LoggerFactory.getLogger(WebSocketContext.class);
    private ConcurrentMap<String, Channel> channelMap = new ConcurrentHashMap<String, Channel>();

    public void put(String id, Channel channel) {
        this.channelMap.put(id, channel);
    }

    public void remove(String id) {
        this.channelMap.remove(id);
    }

    public static final WebSocketContext ins() {
        return LazyHolder.ins;
    }

    public void sendMessage(String id, String message) {
        Channel channel = (Channel)this.channelMap.get(id);
        if (null != channel) {
            TextWebSocketFrame frame = new TextWebSocketFrame(message);
            channel.writeAndFlush((Object)frame);
        }
    }

    public ConcurrentMap<String, Channel> getChannelMap() {
        return this.channelMap;
    }

    private static final class LazyHolder {
        private static final WebSocketContext ins = new WebSocketContext();

        private LazyHolder() {
        }
    }
}

