/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.common;

import io.netty.channel.epoll.Epoll;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);
    public static final String LOCALHOST = "127.0.0.1";
    private static boolean isLinuxPlatform = false;
    private static volatile InetAddress LOCAL_ADDRESS = null;
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String ANYHOST = "0.0.0.0";
    public static final String DOCKERHOST = "172.17.0.1";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");

    public static boolean useEpoll() {
        return NetUtils.isLinuxPlatform() && Epoll.isAvailable();
    }

    public static boolean isLinuxPlatform() {
        return isLinuxPlatform;
    }

    public static String getLocalHost() {
        InetAddress address = NetUtils.getLocalAddress();
        return address == null ? LOCALHOST : address.getHostAddress();
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetUtils.getLocalAddress0();
        return localAddress;
    }

    private static InetAddress getLocalAddress0() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (localAddress instanceof Inet6Address) {
                Inet6Address address = (Inet6Address)localAddress;
                if (NetUtils.isValidV6Address(address)) {
                    return NetUtils.normalizeV6Address(address);
                }
            } else if (NetUtils.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage());
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (null == interfaces) {
                return localAddress;
            }
            while (interfaces.hasMoreElements()) {
                try {
                    NetworkInterface network = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = network.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        try {
                            InetAddress address = addresses.nextElement();
                            if (address instanceof Inet6Address) {
                                Inet6Address v6Address = (Inet6Address)address;
                                if (!NetUtils.isValidV6Address(v6Address)) continue;
                                return NetUtils.normalizeV6Address(v6Address);
                            }
                            if (!NetUtils.isValidAddress(address)) continue;
                            return address;
                        }
                        catch (Throwable e) {
                            log.warn(e.getMessage());
                        }
                    }
                }
                catch (Throwable e) {
                    log.warn(e.getMessage());
                }
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage());
        }
        return localAddress;
    }

    static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        if (null != name && name.startsWith("172")) {
            return false;
        }
        return name != null && !ANYHOST.equals(name) && !LOCALHOST.equals(name) && !DOCKERHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + "%" + address.getScopeId());
            }
            catch (UnknownHostException e) {
                log.debug("Unknown IPV6 address: ", (Throwable)e);
            }
        }
        return address;
    }

    static boolean isValidV6Address(Inet6Address address) {
        boolean preferIpv6 = Boolean.getBoolean("java.net.preferIPv6Addresses");
        if (!preferIpv6) {
            return false;
        }
        try {
            return address.isReachable(100);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static {
        if (OS_NAME != null && OS_NAME.toLowerCase().indexOf("linux") >= 0) {
            isLinuxPlatform = true;
        }
    }
}

