/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.google.common.collect.Maps;
import com.xiaomi.data.push.client.HttpClientV2;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class NacosNaming {
    private static final Logger log = LoggerFactory.getLogger(NacosNaming.class);
    @Value(value="${nacos_naming_addr:}")
    private String serverAddr;
    private String username;
    private String password;
    private String addr;
    private NamingService namingService;

    public void setNamingService(NamingService namingService) {
        this.namingService = namingService;
    }

    public void init() {
        if (null != this.namingService) {
            return;
        }
        if (this.serverAddr == null || this.serverAddr.length() == 0) {
            throw new RuntimeException("serverAddr = null");
        }
        this.addr = this.serverAddr;
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        properties.put("close_docean_rpc", "true");
        if (this.username != null && !this.username.equals("")) {
            properties.put("username", this.username);
        }
        if (this.password != null && !this.password.equals("")) {
            properties.put("password", this.password);
        }
        try {
            this.namingService = NacosFactory.createNamingService((Properties)properties);
        }
        catch (Exception e) {
            log.error("[NacosNaming.init] fail to init , serverAddr:{}, dataId: {}, group: {}, msg: {}", (Object)this.serverAddr, (Object)e.getCause());
        }
    }

    public void registerInstance(String serviceName, String ip, int port) throws NacosException {
        this.namingService.registerInstance(serviceName, ip, port);
    }

    public void registerInstance(String serviceName, Instance instance) throws NacosException {
        this.namingService.registerInstance(serviceName, instance);
    }

    public void registerInstance(String serviceName, String ip, int port, String group) throws NacosException {
        if (!StringUtils.isEmpty((Object)group)) {
            serviceName = group + ":" + (String)serviceName;
        }
        this.registerInstance((String)serviceName, ip, port);
    }

    public void deregisterInstance(String serviceName, String ip, int port) throws NacosException {
        this.namingService.deregisterInstance(serviceName, ip, port);
    }

    public void deregisterInstance(String serviceName, String ip, int port, String group) throws NacosException {
        if (!StringUtils.isEmpty((Object)group)) {
            serviceName = group + ":" + (String)serviceName;
        }
        this.deregisterInstance((String)serviceName, ip, port);
    }

    public List<Instance> getAllInstances(String serviceName) throws NacosException {
        return this.namingService.getAllInstances(serviceName);
    }

    public void subscribe(String serviceName, EventListener listener) {
        try {
            this.namingService.subscribe(serviceName, listener);
        }
        catch (NacosException e) {
            log.error("nacos subscribe error:{}", (Object)e.getMessage());
        }
    }

    public void subscribe(String serviceName, String group, EventListener listener) {
        try {
            this.namingService.subscribe(serviceName, group, listener);
        }
        catch (NacosException e) {
            log.error("nacos subscribe error:{}", (Object)e.getMessage());
        }
    }

    public void unsubscribe(String serviceName, EventListener eventListener) {
        try {
            this.namingService.unsubscribe(serviceName, eventListener);
        }
        catch (NacosException e) {
            log.error("nacos unsubscribe error:{}", (Object)e.getMessage());
        }
    }

    private String getNamingServer() {
        String[] array = this.addr.split(",");
        if (array.length > 0) {
            return array[0];
        }
        throw new RuntimeException("serverAddr is null");
    }

    public ListView<String> getServicesOfServer(int page, int pagesize) {
        try {
            return this.namingService.getServicesOfServer(page, pagesize);
        }
        catch (NacosException e) {
            log.error("getServicesOfServer error:{}", (Object)e.getMessage());
            return null;
        }
    }

    public Instance selectOneHealthInstance(String serviceName) {
        try {
            return this.namingService.selectOneHealthyInstance(serviceName);
        }
        catch (NacosException e) {
            log.error("selectOneHealthInstance error:{}", (Object)e.getMessage());
            return null;
        }
    }

    public String login(String username, String password) {
        HashMap headers = Maps.newHashMap();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return HttpClientV2.post((String)("http://" + this.getNamingServer() + "/nacos/v1/auth/users/login"), (String)("username=" + username + "&password=" + password), (Map)headers, (int)1000);
    }

    public String serviceList(String namespaceId, int page, int pageSize, String keyword) {
        String res = HttpClientV2.get((String)("http://" + this.getNamingServer() + "/nacos/v1/ns/catalog/serviceList?startPg=" + page + "&pgSize=" + pageSize + "&keyword=" + keyword + "&namespaceId=" + namespaceId), (Map)Maps.newHashMap());
        return res;
    }

    public String serviceList2(String namespaceId, int page, int pageSize, String keyword) {
        String params = "?hasIpCount=true&withInstances=false&pageNo=1&pageSize=10&serviceNameParam=" + keyword;
        if (!StringUtils.isEmpty((Object)namespaceId) && !StringUtils.isEmpty((Object)namespaceId.trim())) {
            params = params + "&namespaceId=" + namespaceId;
        }
        return HttpClientV2.get((String)("http://" + this.getNamingServer() + "/nacos/v1/ns/catalog/services" + params), (Map)Maps.newHashMap());
    }

    public String serviceList2(String namespaceId, int page, int pageSize, String keyword, String accessToken) {
        String params = "?hasIpCount=true&withInstances=false&pageNo=1&pageSize=10&serviceNameParam=" + keyword + "&accessToken=" + accessToken;
        if (!StringUtils.isEmpty((Object)namespaceId) && !StringUtils.isEmpty((Object)namespaceId.trim())) {
            params = params + "&namespaceId=" + namespaceId;
        }
        return HttpClientV2.get((String)("http://" + this.getNamingServer() + "/nacos/v1/ns/catalog/services" + params), (Map)Maps.newHashMap());
    }

    public String serviceList2(String namespaceId, int page, int pageSize, boolean withInstances, String accessToken) {
        String params = "?hasIpCount=true&withInstances=false&pageNo=1&pageSize=10&withInstances=" + withInstances + "&accessToken=" + accessToken;
        if (!StringUtils.isEmpty((Object)namespaceId) && !StringUtils.isEmpty((Object)namespaceId.trim())) {
            params = params + "&namespaceId=" + namespaceId;
        }
        return HttpClientV2.get((String)("http://" + this.getNamingServer() + "/nacos/v1/ns/catalog/services" + params), (Map)Maps.newHashMap());
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public NamingService getNamingService() {
        return this.namingService;
    }
}

