/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.alertManagerClient;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.prometheus.agent.client.Client;
import org.apache.ozhera.prometheus.agent.param.alertManager.AlertManagerConfig;
import org.apache.ozhera.prometheus.agent.param.alertManager.Group;
import org.apache.ozhera.prometheus.agent.param.alertManager.Rule;
import org.apache.ozhera.prometheus.agent.service.prometheus.RuleAlertService;
import org.apache.ozhera.prometheus.agent.util.CommitPoolUtil;
import org.apache.ozhera.prometheus.agent.util.FileUtil;
import org.apache.ozhera.prometheus.agent.util.Http;
import org.apache.ozhera.prometheus.agent.util.YamlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AlertManagerClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(AlertManagerClient.class);
    @NacosValue(value="${job.alertManager.reloadAddr}", autoRefreshed=true)
    private String reloadAddr;
    @NacosValue(value="${job.alertManager.filePath}", autoRefreshed=true)
    private String filePath;
    private String backFilePath;
    @NacosValue(value="${job.alertManager.enabled}", autoRefreshed=true)
    private String enabled;
    private boolean firstInitSign = false;
    @Autowired
    RuleAlertService ruleAlertService;
    private Map<String, List<Rule>> localRuleList = new HashMap<String, List<Rule>>();
    private static final Gson gson = new Gson();
    private ReentrantLock lock = new ReentrantLock();

    @PostConstruct
    public void init() {
        this.backFilePath = this.filePath + ".bak";
        if (this.enabled.equals("true")) {
            this.GetLocalConfigs();
            this.CompareAndReload();
        } else {
            log.info("AlertManagerClient not init");
        }
    }

    @Override
    public void GetLocalConfigs() {
        CommitPoolUtil.ALERTMANAGER_LOCAL_CONFIG_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            log.info("AlertManagerClient start GetLocalConfigs");
            try {
                List allRuleAlertList = this.ruleAlertService.GetAllRuleAlertList();
                this.localRuleList.clear();
                log.info("AlertManagerClient GetLocalConfigs allRuleAlertList: {}", (Object)allRuleAlertList);
                allRuleAlertList.forEach(item -> {
                    String tmpGroup = item.getAlert_group();
                    Rule rule = new Rule();
                    rule.setAlert(item.getName());
                    rule.setAnnotations(this.transAnnotation2Map(item.getAnnotation()));
                    rule.setLabels(this.transLabel2Map(item.getLabels()));
                    rule.setExpr(item.getExpr());
                    rule.setFor(item.getAlertFor());
                    if (this.localRuleList.containsKey(tmpGroup)) {
                        this.localRuleList.get(tmpGroup).add(rule);
                    } else {
                        ArrayList rules = new ArrayList();
                        this.localRuleList.put(tmpGroup, rules);
                        this.localRuleList.get(tmpGroup).add(rule);
                    }
                });
                log.info("AlertManagerClient GetLocalConfigs done!");
                this.firstInitSign = true;
            }
            catch (Exception e) {
                log.error("AlertManagerClient GetLocalConfigs error:{}", (Object)e.getMessage());
            }
            finally {
                log.info("AlertManagerClient GetLocalConfigs batch time:{}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void CompareAndReload() {
        CommitPoolUtil.ALERTMANAGER_COMPARE_RELOAD_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            try {
                if (this.localRuleList.isEmpty()) {
                    log.info("localRuleList is empty and no need reload");
                    return;
                }
                if (!this.firstInitSign) {
                    log.info("AlertManagerClient CompareAndReload waiting..");
                    return;
                }
                log.info("AlertManagerClient start CompareAndReload");
                AlertManagerConfig ruleAlertConfig = this.getRuleAlertConfig(this.filePath);
                ArrayList<Group> group = new ArrayList<Group>();
                for (Map.Entry<String, List<Rule>> entry : this.localRuleList.entrySet()) {
                    Group tmpGroup = new Group();
                    tmpGroup.setName(entry.getKey());
                    tmpGroup.setRules(entry.getValue());
                    group.add(tmpGroup);
                }
                ruleAlertConfig.setGroups(group);
                this.writeAlertManagerConfig2Yaml(ruleAlertConfig);
                log.info("AlertManagerClient request reload url :{}", (Object)this.reloadAddr);
                String getReloadRes = Http.innerRequest((String)"", (String)this.reloadAddr, (String)"POST");
                log.info("AlertManagerClient request reload res :{}", (Object)getReloadRes);
                if (getReloadRes.equals("200")) {
                    log.info("AlertManagerClient request reload success");
                    this.deleteBackConfig();
                } else {
                    log.info("AlertManagerClient request reload fail and begin rollback config");
                    boolean rollbackRes = this.restoreConfiguration(this.backFilePath, this.filePath);
                    log.info("AlertManagerClient request reload fail and rollbackRes: {}", (Object)rollbackRes);
                }
            }
            catch (Exception e) {
                log.error("AlertManagerClient CompareAndReload error: {}", (Throwable)e);
            }
            finally {
                log.info("AlertManagerClient CompareAndReload batch time:{}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    private Map<String, String> transLabel2Map(String labels) {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        try {
            Arrays.stream(labels.split(",")).forEach(item -> {
                String[] split = item.split("=", 2);
                if (split.length != 2) {
                    return;
                }
                labelMap.put(split[0], split[1]);
            });
            return labelMap;
        }
        catch (Exception e) {
            log.error("AlertManagerClient transLabel2Map error: {}", (Throwable)e);
            return labelMap;
        }
    }

    private Map<String, String> transAnnotation2Map(String annotations) {
        Map annotationMap = (Map)gson.fromJson(annotations, Map.class);
        return annotationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlertManagerConfig getRuleAlertConfig(String path) {
        this.lock.lock();
        try {
            log.info("AlertManagerClient getRuleAlertConfig path : {}", (Object)path);
            String content = FileUtil.LoadFile((String)path);
            AlertManagerConfig alertManagerConfig = (AlertManagerConfig)YamlUtil.toObject((String)content, AlertManagerConfig.class);
            log.info("AlertManagerClient config : {}", (Object)alertManagerConfig);
            AlertManagerConfig alertManagerConfig2 = alertManagerConfig;
            return alertManagerConfig2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeAlertManagerConfig2Yaml(AlertManagerConfig alertManagerConfig) {
        log.info("AlertManagerClient write config : {}", (Object)alertManagerConfig);
        String alertManagerYml = YamlUtil.toYaml((Object)alertManagerConfig);
        if (!this.isFileExists(this.filePath)) {
            log.error("AlertManagerClient writeAlertManagerConfig2Yaml no files here path: {}", (Object)this.filePath);
            return;
        }
        this.backUpConfig();
        String writeRes = FileUtil.WriteFile((String)this.filePath, (String)alertManagerYml);
        if (StringUtils.isEmpty((CharSequence)writeRes)) {
            log.error("AlertManagerClient WriteFile Error");
        }
        log.info("AlertManagerClient WriteFile res : {}", (Object)writeRes);
    }

    private void backUpConfig() {
        String content;
        String writeRes;
        if (!this.isFileExists(this.filePath)) {
            log.error("AlertManagerClient backUpConfig no files here path: {}", (Object)this.filePath);
            return;
        }
        if (!this.isFileExists(this.backFilePath)) {
            log.info("AlertManagerClient backUpConfig backFile does not exist and begin create");
            FileUtil.GenerateFile((String)this.backFilePath);
        }
        if (StringUtils.isEmpty((CharSequence)(writeRes = FileUtil.WriteFile((String)this.backFilePath, (String)(content = FileUtil.LoadFile((String)this.filePath)))))) {
            log.error("AlertManagerClient backUpConfig WriteFile Error");
        } else {
            log.info("AlertManagerClient backUpConfig WriteFile success");
        }
    }

    private void deleteBackConfig() {
        if (!this.isFileExists(this.backFilePath)) {
            log.error("AlertManagerClient deleteBackConfig no files here path: {}", (Object)this.backFilePath);
            return;
        }
        boolean deleteRes = FileUtil.DeleteFile((String)this.backFilePath);
        if (deleteRes) {
            log.info("AlertManagerClient deleteBackConfig delete success");
        } else {
            log.error("AlertManagerClient deleteBackConfig delete fail");
        }
    }

    private boolean isFileExists(String filePath) {
        return FileUtil.IsHaveFile((String)filePath);
    }

    private boolean restoreConfiguration(String oldFilePath, String newFilePath) {
        log.info("AlertManagerClient restoreConfiguration oldPath: {}, newPath: {}", (Object)oldFilePath, (Object)newFilePath);
        boolean b = FileUtil.RenameFile((String)oldFilePath, (String)newFilePath);
        return b;
    }
}

