/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.exception;

import java.util.HashMap;
import org.apache.ozhera.app.common.Result;
import org.apache.ozhera.app.enums.BizCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice(basePackages={"org.apache.ozhera.app.controller"})
public class AppExceptionControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(AppExceptionControllerAdvice.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result handleValidException(MethodArgumentNotValidException exception) {
        log.info("\u6570\u636e\u7c7b\u578b\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38:{},\u5f02\u5e38\u7c7b\u578b{}", (Object)exception.getMessage(), exception.getClass());
        HashMap errorMap = new HashMap();
        exception.getBindingResult().getFieldErrors().forEach(fieldError -> errorMap.put(fieldError.getField(), fieldError.getDefaultMessage()));
        return Result.error((Integer)BizCodeEnum.VALID_EXCEPTION.getCode(), (String)BizCodeEnum.VALID_EXCEPTION.getMsg(), errorMap);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result handleParameterException(MissingServletRequestParameterException exception) {
        log.info("\u53c2\u6570\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38{}\uff0c\u5f02\u5e38\u7c7b\u578b{}", (Object)exception.getMessage(), exception.getClass());
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put(exception.getParameterName(), exception.getParameterType());
        return Result.error((Integer)BizCodeEnum.VALID_EXCEPTION.getCode(), (String)exception.getMessage(), errorMap);
    }

    @ExceptionHandler(value={Exception.class})
    public Result handleException(Exception e) {
        log.info("\u670d\u52a1\u5668\u5f02\u5e38", (Throwable)e);
        return Result.error((String)e.getMessage());
    }
}

