/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.controller;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.response.AppBaseInfo;
import org.apache.ozhera.app.api.service.HeraAppService;
import org.apache.ozhera.app.common.Result;
import org.apache.ozhera.app.enums.CommonError;
import org.apache.ozhera.app.model.HeraAppBaseInfo;
import org.apache.ozhera.app.response.anno.OriginalResponse;
import org.apache.ozhera.app.service.HeraAppRoleService;
import org.apache.ozhera.app.service.impl.HeraAppBaseInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AppController {
    private static final Logger log = LoggerFactory.getLogger(AppController.class);
    @Autowired
    private HeraAppBaseInfoService heraAppBaseInfoService;
    private final HeraAppService heraAppService;
    @Autowired
    private HeraAppRoleService heraAppRoleService;

    public AppController(HeraAppService heraAppService) {
        this.heraAppService = heraAppService;
    }

    @GetMapping(value={"test"})
    public String test() {
        return "hello world";
    }

    @GetMapping(value={"query/app/id/info"})
    public AppBaseInfo queryByIdInfo(@RequestParam(value="id") Long id) {
        AppBaseInfo appBaseInfo = this.heraAppService.queryById(id);
        return appBaseInfo;
    }

    @GetMapping(value={"query/app/id"})
    public HeraAppBaseInfo queryById(@RequestParam(value="id") Long id) {
        HeraAppBaseInfo heraAppBaseInfo = this.heraAppBaseInfoService.queryById(id);
        return heraAppBaseInfo;
    }

    @GetMapping(value={"query/app/log"})
    public List<AppBaseInfo> queryAppInfoWithLog(String appName, Integer type) {
        return this.heraAppService.queryAppInfoWithLog(appName, type);
    }

    @PostMapping(value={"/hera/app/add"})
    public Result heraAppAdd(@RequestBody HeraAppBaseInfo heraAppBaseInfo) {
        if (StringUtils.isBlank((CharSequence)heraAppBaseInfo.getBindId()) || StringUtils.isBlank((CharSequence)heraAppBaseInfo.getAppName())) {
            log.error("heraAppAdd param error! BindId or AppName is blank!heraAppBaseInfo:{}", (Object)heraAppBaseInfo);
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        if (heraAppBaseInfo.getAppType() == null) {
            heraAppBaseInfo.setAppType(Integer.valueOf(0));
        }
        if (heraAppBaseInfo.getBindType() == null) {
            heraAppBaseInfo.setBindType(Integer.valueOf(0));
        }
        if (heraAppBaseInfo.getPlatformType() == null) {
            heraAppBaseInfo.setPlatformType(Integer.valueOf(0));
        }
        try {
            this.heraAppBaseInfoService.create(heraAppBaseInfo);
            return Result.success();
        }
        catch (Exception e) {
            log.error("heraAppAdd error! {}", (Throwable)e);
            return Result.fail((CommonError)CommonError.UnknownError);
        }
    }

    @GetMapping(value={"/mimonitor/addHeraRoleGet"})
    public Result addRoleByAppIdAndPlat(String appId, Integer plat, String user) {
        try {
            this.heraAppRoleService.addRoleGet(appId, plat, user);
            return Result.success();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.fail((CommonError)CommonError.UnknownError);
        }
    }

    @PostMapping(value={"app/base/query/batch"})
    public List<AppBaseInfo> queryByIds(@RequestBody List<Long> ids) {
        return this.heraAppService.queryByIds(ids);
    }

    @GetMapping(value={"app/original/response"})
    @OriginalResponse
    public List<String> testOriginalResponse() {
        return Lists.newArrayList((Object[])new String[]{"122343", "\u4e2d\u56fd", "5656.66"});
    }
}

