/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.stream.StreamReader;
import com.alibaba.fastjson2.support.csv.CSVReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public class CSVMaxComputeUtils {
    public static String genCreateTable(File file, String tableName) throws IOException {
        CSVReader csvReader = CSVReader.of((File)file, (Type[])new Type[0]);
        csvReader.readHeader();
        csvReader.statAll();
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(tableName).append(" (\n");
        List columns = csvReader.getColumnStats();
        for (int i = 0; i < columns.size(); ++i) {
            StreamReader.ColumnStat columnStat = (StreamReader.ColumnStat)columns.get(i);
            String columnName = columnStat.name;
            columnName = columnName.replace(' ', '_');
            columnName = columnName.replace('-', '_');
            columnName = columnName.replace('+', '_');
            columnName = columnName.replace('.', '_');
            boolean special = false;
            for (int j = 0; j < columnName.length(); ++j) {
                boolean firstIdent;
                char ch = columnName.charAt(j);
                boolean bl = firstIdent = ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_';
                if (j == 0 && !firstIdent) {
                    special = true;
                    break;
                }
                if (firstIdent || ch >= '0' && ch <= '9') continue;
                special = true;
                break;
            }
            if (!special && columnName.length() > 20) {
                special = true;
            }
            sql.append('\t');
            if (special) {
                sql.append("COL_" + i);
            } else {
                sql.append(columnName);
            }
            sql.append(' ');
            sql.append(columnStat.getInferSQLType());
            if (special) {
                sql.append(" COMMENT '");
                String comment = columnStat.name.replaceAll("'", "''");
                sql.append(comment).append('\'');
            }
            if (i != columns.size() - 1) {
                sql.append(',');
            }
            sql.append("\n");
        }
        sql.append(");");
        return sql.toString();
    }
}

