/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.api.enums;

import java.util.Arrays;
import java.util.stream.Stream;

public enum MiddlewareEnum {
    ROCKETMQ(1, "rocketmq", "RocketMQService"),
    KAFKA(2, "kafka", "KafkaService"),
    NCOS(3, "nacos", ""),
    ELASTICSEARCH(4, "elasticsearch", ""),
    HDFS(5, "hdfs", ""),
    LOKI(6, "loki", "");

    private final Integer code;
    private final String name;
    private final String serviceName;

    private MiddlewareEnum(Integer code, String name, String serviceName) {
        this.code = code;
        this.name = name;
        this.serviceName = serviceName;
    }

    public static MiddlewareEnum queryByCode(Integer code) {
        if (null == code) {
            return null;
        }
        return ((Stream)Arrays.stream(MiddlewareEnum.values()).sequential()).filter(middlewareEnum -> middlewareEnum.getCode().intValue() == code.intValue()).findFirst().orElse(null);
    }

    public static String queryNameByCode(Integer code) {
        String name = "";
        for (MiddlewareEnum middlewareEnum : MiddlewareEnum.values()) {
            if (!middlewareEnum.getCode().equals(code)) continue;
            name = middlewareEnum.getName();
        }
        return name;
    }

    public static MiddlewareEnum queryByName(String name) {
        if (name == null || "".equals(name)) {
            return null;
        }
        return ((Stream)Arrays.stream(MiddlewareEnum.values()).sequential()).filter(middlewareEnum -> middlewareEnum.getName().equals(name)).findFirst().orElse(null);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

