/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.balancer.KeyManager;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
public class NameNodeConnector
implements Closeable {
    private static final Log LOG = LogFactory.getLog(NameNodeConnector.class);
    public static final int DEFAULT_MAX_IDLE_ITERATIONS = 5;
    private static boolean write2IdFile = true;
    private final URI nameNodeUri;
    private final String blockpoolID;
    private final NamenodeProtocol namenode;
    private final ClientProtocol client;
    private final KeyManager keyManager;
    final AtomicBoolean fallbackToSimpleAuth = new AtomicBoolean(false);
    private final DistributedFileSystem fs;
    private final Path idPath;
    private final OutputStream out;
    private final List<Path> targetPaths;
    private final AtomicLong bytesMoved = new AtomicLong();
    private final int maxNotChangedIterations;
    private int notChangedIterations = 0;

    public static List<NameNodeConnector> newNameNodeConnectors(Collection<URI> namenodes, String name, Path idPath, Configuration conf, int maxIdleIterations) throws IOException {
        ArrayList<NameNodeConnector> connectors = new ArrayList<NameNodeConnector>(namenodes.size());
        for (URI uri : namenodes) {
            NameNodeConnector nnc = new NameNodeConnector(name, uri, idPath, null, conf, maxIdleIterations);
            nnc.getKeyManager().startBlockKeyUpdater();
            connectors.add(nnc);
        }
        return connectors;
    }

    public static List<NameNodeConnector> newNameNodeConnectors(Map<URI, List<Path>> namenodes, String name, Path idPath, Configuration conf, int maxIdleIterations) throws IOException {
        ArrayList<NameNodeConnector> connectors = new ArrayList<NameNodeConnector>(namenodes.size());
        for (Map.Entry<URI, List<Path>> entry : namenodes.entrySet()) {
            NameNodeConnector nnc = new NameNodeConnector(name, entry.getKey(), idPath, entry.getValue(), conf, maxIdleIterations);
            nnc.getKeyManager().startBlockKeyUpdater();
            connectors.add(nnc);
        }
        return connectors;
    }

    @VisibleForTesting
    public static void setWrite2IdFile(boolean write2IdFile) {
        NameNodeConnector.write2IdFile = write2IdFile;
    }

    public NameNodeConnector(String name, URI nameNodeUri, Path idPath, List<Path> targetPaths, Configuration conf, int maxNotChangedIterations) throws IOException {
        this.nameNodeUri = nameNodeUri;
        this.idPath = idPath;
        this.targetPaths = targetPaths == null || targetPaths.isEmpty() ? Arrays.asList(new Path("/")) : targetPaths;
        this.maxNotChangedIterations = maxNotChangedIterations;
        this.namenode = NameNodeProxies.createProxy(conf, nameNodeUri, NamenodeProtocol.class).getProxy();
        this.client = NameNodeProxies.createProxy(conf, nameNodeUri, ClientProtocol.class, this.fallbackToSimpleAuth).getProxy();
        this.fs = (DistributedFileSystem)FileSystem.get((URI)nameNodeUri, (Configuration)conf);
        NamespaceInfo namespaceinfo = this.namenode.versionRequest();
        this.blockpoolID = namespaceinfo.getBlockPoolID();
        FsServerDefaults defaults = this.fs.getServerDefaults(new Path("/"));
        this.keyManager = new KeyManager(this.blockpoolID, this.namenode, defaults.getEncryptDataTransfer(), conf);
        this.out = this.checkAndMarkRunning();
        if (this.out == null) {
            throw new IOException("Another " + name + " is running.");
        }
    }

    public DistributedFileSystem getDistributedFileSystem() {
        return this.fs;
    }

    public String getBlockpoolID() {
        return this.blockpoolID;
    }

    AtomicLong getBytesMoved() {
        return this.bytesMoved;
    }

    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        return this.namenode.getBlocks(datanode, size);
    }

    public DatanodeStorageReport[] getLiveDatanodeStorageReport() throws IOException {
        return this.client.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.LIVE);
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public List<Path> getTargetPaths() {
        return this.targetPaths;
    }

    public boolean shouldContinue(long dispatchBlockMoveBytes) {
        if (dispatchBlockMoveBytes > 0L) {
            this.notChangedIterations = 0;
        } else {
            ++this.notChangedIterations;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No block has been moved for " + this.notChangedIterations + " iterations, " + "maximum notChangedIterations before exit is: " + (this.maxNotChangedIterations >= 0 ? Integer.valueOf(this.maxNotChangedIterations) : "Infinite")));
            }
            if (this.maxNotChangedIterations >= 0 && this.notChangedIterations >= this.maxNotChangedIterations) {
                System.out.println("No block has been moved for " + this.notChangedIterations + " iterations. Exiting...");
                return false;
            }
        }
        return true;
    }

    private OutputStream checkAndMarkRunning() throws IOException {
        try {
            if (this.fs.exists(this.idPath)) {
                IOUtils.closeStream((Closeable)this.fs.append(this.idPath));
                this.fs.delete(this.idPath, true);
            }
            FSDataOutputStream fsout = this.fs.create(this.idPath, false);
            this.fs.deleteOnExit(this.idPath);
            if (write2IdFile) {
                fsout.writeBytes(InetAddress.getLocalHost().getHostName());
                fsout.hflush();
            }
            return fsout;
        }
        catch (RemoteException e) {
            if (AlreadyBeingCreatedException.class.getName().equals(e.getClassName())) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void close() {
        this.keyManager.close();
        IOUtils.closeStream((Closeable)this.out);
        if (this.fs != null) {
            try {
                this.fs.delete(this.idPath, true);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Failed to delete " + this.idPath), (Throwable)ioe);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[namenodeUri=" + this.nameNodeUri + ", bpid=" + this.blockpoolID + "]";
    }
}

